// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/networkanalyzer/logging/v1/analyzer_log.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ReportCauseCode int32

const (
	ReportCauseCode_REPORT_CAUSE_CODE_UNSPECIFIED ReportCauseCode = 0
	// VPC Basics
	ReportCauseCode_ROUTE_INVALID_NEXT_HOP_VM_IP_FORWARDING_DISABLED          ReportCauseCode = 1
	ReportCauseCode_ROUTE_INVALID_NEXT_HOP_VM_DELETED                         ReportCauseCode = 2
	ReportCauseCode_ROUTE_INVALID_NEXT_HOP_VM_STOPPED                         ReportCauseCode = 3
	ReportCauseCode_ROUTE_INVALID_NEXT_HOP_ILB_MISCONFIGURED                  ReportCauseCode = 4
	ReportCauseCode_ROUTE_INVALID_NEXT_HOP_VPN_TUNNEL_DELETED                 ReportCauseCode = 5
	ReportCauseCode_ROUTE_INVALID_NEXT_HOP_ILB_BACKEND_IP_FORWARDING_DISABLED ReportCauseCode = 6
	ReportCauseCode_IP_UTILIZATION_IP_ALLOCATION_RATIO_HIGH                   ReportCauseCode = 20
	// Kubernetes Engine
	ReportCauseCode_GKE_NODE_TO_CONTROL_PLANE_BLOCKED_BY_ROUTING_ISSUE                    ReportCauseCode = 201
	ReportCauseCode_GKE_NODE_TO_CONTROL_PLANE_PUBLIC_ENDPOINT_BLOCKED_BY_EGRESS_FIREWALL  ReportCauseCode = 202
	ReportCauseCode_GKE_NODE_TO_CONTROL_PLANE_PRIVATE_ENDPOINT_BLOCKED_BY_EGRESS_FIREWALL ReportCauseCode = 203
	ReportCauseCode_GKE_CONTROL_PLANE_TO_NODE_BLOCKED_BY_ROUTING_ISSUE                    ReportCauseCode = 211
	ReportCauseCode_GKE_CONTROL_PLANE_TO_NODE_BLOCKED_BY_INGRESS_FIREWALL_ON_NODE         ReportCauseCode = 212
	ReportCauseCode_GKE_IP_UTILIZATION_POD_RANGES_ALLOCATION_HIGH                         ReportCauseCode = 221
	ReportCauseCode_GKE_IP_UTILIZATION_POD_RANGES_ALLOCATION_LIMITES_AUTOSCALING          ReportCauseCode = 222
	// Managed Services
	ReportCauseCode_CLOUD_SQL_PRIVATE_IP_BLOCKED_BY_EGRESS_FIREWALL ReportCauseCode = 601
	ReportCauseCode_CLOUD_SQL_PRIVATE_IP_BLOCKED_BY_ROUTING_ISSUE   ReportCauseCode = 602
	ReportCauseCode_CLOUD_SQL_PRIVATE_IP_INSTANCE_NOT_RUNNING       ReportCauseCode = 603
	// Hybrid Connectivity
	ReportCauseCode_DYNAMIC_ROUTE_SHADOWED_FULLY_SHADOWED_BY_SUBNET_ROUTE             ReportCauseCode = 801
	ReportCauseCode_DYNAMIC_ROUTE_SHADOWED_FULLY_SHADOWED_BY_PEERING_SUBNET_ROUTE     ReportCauseCode = 802
	ReportCauseCode_DYNAMIC_ROUTE_SHADOWED_FULLY_SHADOWED_BY_STATIC_ROUTE             ReportCauseCode = 803
	ReportCauseCode_DYNAMIC_ROUTE_SHADOWED_FULLY_SHADOWED_BY_PEERING_STATIC_ROUTE     ReportCauseCode = 804
	ReportCauseCode_DYNAMIC_ROUTE_SHADOWED_PARTIALLY_SHADOWED_BY_SUBNET_ROUTE         ReportCauseCode = 805
	ReportCauseCode_DYNAMIC_ROUTE_SHADOWED_PARTIALLY_SHADOWED_BY_PEERING_SUBNET_ROUTE ReportCauseCode = 806
	ReportCauseCode_DYNAMIC_ROUTE_SHADOWED_PARTIALLY_SHADOWED_BY_STATIC_ROUTE         ReportCauseCode = 807
	ReportCauseCode_DYNAMIC_ROUTE_SHADOWED_PARTIALLY_SHADOWED_BY_PEERING_STATIC_ROUTE ReportCauseCode = 808
	// Network Services
	ReportCauseCode_LOAD_BALANCER_HEALTH_CHECK_FIREWALL_HEALTH_CHECK_FIREWALL_NOT_CONFIGURED ReportCauseCode = 1001
	ReportCauseCode_LOAD_BALANCER_HEALTH_CHECK_FIREWALL_HEALTH_CHECK_RANGE_BLOCKED           ReportCauseCode = 1002
	ReportCauseCode_LOAD_BALANCER_HEALTH_CHECK_FIREWALL_FIREWALL_CONFIG_INCONSISTENT         ReportCauseCode = 1003
)

// Enum value maps for ReportCauseCode.
var (
	ReportCauseCode_name = map[int32]string{
		0:    "REPORT_CAUSE_CODE_UNSPECIFIED",
		1:    "ROUTE_INVALID_NEXT_HOP_VM_IP_FORWARDING_DISABLED",
		2:    "ROUTE_INVALID_NEXT_HOP_VM_DELETED",
		3:    "ROUTE_INVALID_NEXT_HOP_VM_STOPPED",
		4:    "ROUTE_INVALID_NEXT_HOP_ILB_MISCONFIGURED",
		5:    "ROUTE_INVALID_NEXT_HOP_VPN_TUNNEL_DELETED",
		6:    "ROUTE_INVALID_NEXT_HOP_ILB_BACKEND_IP_FORWARDING_DISABLED",
		20:   "IP_UTILIZATION_IP_ALLOCATION_RATIO_HIGH",
		201:  "GKE_NODE_TO_CONTROL_PLANE_BLOCKED_BY_ROUTING_ISSUE",
		202:  "GKE_NODE_TO_CONTROL_PLANE_PUBLIC_ENDPOINT_BLOCKED_BY_EGRESS_FIREWALL",
		203:  "GKE_NODE_TO_CONTROL_PLANE_PRIVATE_ENDPOINT_BLOCKED_BY_EGRESS_FIREWALL",
		211:  "GKE_CONTROL_PLANE_TO_NODE_BLOCKED_BY_ROUTING_ISSUE",
		212:  "GKE_CONTROL_PLANE_TO_NODE_BLOCKED_BY_INGRESS_FIREWALL_ON_NODE",
		221:  "GKE_IP_UTILIZATION_POD_RANGES_ALLOCATION_HIGH",
		222:  "GKE_IP_UTILIZATION_POD_RANGES_ALLOCATION_LIMITES_AUTOSCALING",
		601:  "CLOUD_SQL_PRIVATE_IP_BLOCKED_BY_EGRESS_FIREWALL",
		602:  "CLOUD_SQL_PRIVATE_IP_BLOCKED_BY_ROUTING_ISSUE",
		603:  "CLOUD_SQL_PRIVATE_IP_INSTANCE_NOT_RUNNING",
		801:  "DYNAMIC_ROUTE_SHADOWED_FULLY_SHADOWED_BY_SUBNET_ROUTE",
		802:  "DYNAMIC_ROUTE_SHADOWED_FULLY_SHADOWED_BY_PEERING_SUBNET_ROUTE",
		803:  "DYNAMIC_ROUTE_SHADOWED_FULLY_SHADOWED_BY_STATIC_ROUTE",
		804:  "DYNAMIC_ROUTE_SHADOWED_FULLY_SHADOWED_BY_PEERING_STATIC_ROUTE",
		805:  "DYNAMIC_ROUTE_SHADOWED_PARTIALLY_SHADOWED_BY_SUBNET_ROUTE",
		806:  "DYNAMIC_ROUTE_SHADOWED_PARTIALLY_SHADOWED_BY_PEERING_SUBNET_ROUTE",
		807:  "DYNAMIC_ROUTE_SHADOWED_PARTIALLY_SHADOWED_BY_STATIC_ROUTE",
		808:  "DYNAMIC_ROUTE_SHADOWED_PARTIALLY_SHADOWED_BY_PEERING_STATIC_ROUTE",
		1001: "LOAD_BALANCER_HEALTH_CHECK_FIREWALL_HEALTH_CHECK_FIREWALL_NOT_CONFIGURED",
		1002: "LOAD_BALANCER_HEALTH_CHECK_FIREWALL_HEALTH_CHECK_RANGE_BLOCKED",
		1003: "LOAD_BALANCER_HEALTH_CHECK_FIREWALL_FIREWALL_CONFIG_INCONSISTENT",
	}
	ReportCauseCode_value = map[string]int32{
		"REPORT_CAUSE_CODE_UNSPECIFIED":                                            0,
		"ROUTE_INVALID_NEXT_HOP_VM_IP_FORWARDING_DISABLED":                         1,
		"ROUTE_INVALID_NEXT_HOP_VM_DELETED":                                        2,
		"ROUTE_INVALID_NEXT_HOP_VM_STOPPED":                                        3,
		"ROUTE_INVALID_NEXT_HOP_ILB_MISCONFIGURED":                                 4,
		"ROUTE_INVALID_NEXT_HOP_VPN_TUNNEL_DELETED":                                5,
		"ROUTE_INVALID_NEXT_HOP_ILB_BACKEND_IP_FORWARDING_DISABLED":                6,
		"IP_UTILIZATION_IP_ALLOCATION_RATIO_HIGH":                                  20,
		"GKE_NODE_TO_CONTROL_PLANE_BLOCKED_BY_ROUTING_ISSUE":                       201,
		"GKE_NODE_TO_CONTROL_PLANE_PUBLIC_ENDPOINT_BLOCKED_BY_EGRESS_FIREWALL":     202,
		"GKE_NODE_TO_CONTROL_PLANE_PRIVATE_ENDPOINT_BLOCKED_BY_EGRESS_FIREWALL":    203,
		"GKE_CONTROL_PLANE_TO_NODE_BLOCKED_BY_ROUTING_ISSUE":                       211,
		"GKE_CONTROL_PLANE_TO_NODE_BLOCKED_BY_INGRESS_FIREWALL_ON_NODE":            212,
		"GKE_IP_UTILIZATION_POD_RANGES_ALLOCATION_HIGH":                            221,
		"GKE_IP_UTILIZATION_POD_RANGES_ALLOCATION_LIMITES_AUTOSCALING":             222,
		"CLOUD_SQL_PRIVATE_IP_BLOCKED_BY_EGRESS_FIREWALL":                          601,
		"CLOUD_SQL_PRIVATE_IP_BLOCKED_BY_ROUTING_ISSUE":                            602,
		"CLOUD_SQL_PRIVATE_IP_INSTANCE_NOT_RUNNING":                                603,
		"DYNAMIC_ROUTE_SHADOWED_FULLY_SHADOWED_BY_SUBNET_ROUTE":                    801,
		"DYNAMIC_ROUTE_SHADOWED_FULLY_SHADOWED_BY_PEERING_SUBNET_ROUTE":            802,
		"DYNAMIC_ROUTE_SHADOWED_FULLY_SHADOWED_BY_STATIC_ROUTE":                    803,
		"DYNAMIC_ROUTE_SHADOWED_FULLY_SHADOWED_BY_PEERING_STATIC_ROUTE":            804,
		"DYNAMIC_ROUTE_SHADOWED_PARTIALLY_SHADOWED_BY_SUBNET_ROUTE":                805,
		"DYNAMIC_ROUTE_SHADOWED_PARTIALLY_SHADOWED_BY_PEERING_SUBNET_ROUTE":        806,
		"DYNAMIC_ROUTE_SHADOWED_PARTIALLY_SHADOWED_BY_STATIC_ROUTE":                807,
		"DYNAMIC_ROUTE_SHADOWED_PARTIALLY_SHADOWED_BY_PEERING_STATIC_ROUTE":        808,
		"LOAD_BALANCER_HEALTH_CHECK_FIREWALL_HEALTH_CHECK_FIREWALL_NOT_CONFIGURED": 1001,
		"LOAD_BALANCER_HEALTH_CHECK_FIREWALL_HEALTH_CHECK_RANGE_BLOCKED":           1002,
		"LOAD_BALANCER_HEALTH_CHECK_FIREWALL_FIREWALL_CONFIG_INCONSISTENT":         1003,
	}
)

func (x ReportCauseCode) Enum() *ReportCauseCode {
	p := new(ReportCauseCode)
	*p = x
	return p
}

func (x ReportCauseCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReportCauseCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_enumTypes[0].Descriptor()
}

func (ReportCauseCode) Type() protoreflect.EnumType {
	return &file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_enumTypes[0]
}

func (x ReportCauseCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReportCauseCode.Descriptor instead.
func (ReportCauseCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_rawDescGZIP(), []int{0}
}

// Priority level of an report.
type Report_Priority int32

const (
	Report_SEVERITY_UNSPECIFIED Report_Priority = 0
	Report_CRITICAL             Report_Priority = 1
	Report_HIGH                 Report_Priority = 2
	Report_MEDIUM               Report_Priority = 3
	Report_LOW                  Report_Priority = 4
)

// Enum value maps for Report_Priority.
var (
	Report_Priority_name = map[int32]string{
		0: "SEVERITY_UNSPECIFIED",
		1: "CRITICAL",
		2: "HIGH",
		3: "MEDIUM",
		4: "LOW",
	}
	Report_Priority_value = map[string]int32{
		"SEVERITY_UNSPECIFIED": 0,
		"CRITICAL":             1,
		"HIGH":                 2,
		"MEDIUM":               3,
		"LOW":                  4,
	}
)

func (x Report_Priority) Enum() *Report_Priority {
	p := new(Report_Priority)
	*p = x
	return p
}

func (x Report_Priority) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Report_Priority) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_enumTypes[1].Descriptor()
}

func (Report_Priority) Type() protoreflect.EnumType {
	return &file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_enumTypes[1]
}

func (x Report_Priority) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Report_Priority.Descriptor instead.
func (Report_Priority) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_rawDescGZIP(), []int{0, 0}
}

// Type of an report.
type Report_Type int32

const (
	Report_REPORT_TYPE_UNSPECIFIED Report_Type = 0
	Report_INFO                    Report_Type = 1
	Report_WARNING                 Report_Type = 2
	Report_ERROR                   Report_Type = 3
)

// Enum value maps for Report_Type.
var (
	Report_Type_name = map[int32]string{
		0: "REPORT_TYPE_UNSPECIFIED",
		1: "INFO",
		2: "WARNING",
		3: "ERROR",
	}
	Report_Type_value = map[string]int32{
		"REPORT_TYPE_UNSPECIFIED": 0,
		"INFO":                    1,
		"WARNING":                 2,
		"ERROR":                   3,
	}
)

func (x Report_Type) Enum() *Report_Type {
	p := new(Report_Type)
	*p = x
	return p
}

func (x Report_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Report_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_enumTypes[2].Descriptor()
}

func (Report_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_enumTypes[2]
}

func (x Report_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Report_Type.Descriptor instead.
func (Report_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_rawDescGZIP(), []int{0, 1}
}

// Status of an report.
type Report_ReportStatus int32

const (
	Report_REPORT_STATUS_UNSPECIFIED Report_ReportStatus = 0
	Report_ACTIVE                    Report_ReportStatus = 1
	Report_FIXED                     Report_ReportStatus = 2
	Report_DISMISSED                 Report_ReportStatus = 3
)

// Enum value maps for Report_ReportStatus.
var (
	Report_ReportStatus_name = map[int32]string{
		0: "REPORT_STATUS_UNSPECIFIED",
		1: "ACTIVE",
		2: "FIXED",
		3: "DISMISSED",
	}
	Report_ReportStatus_value = map[string]int32{
		"REPORT_STATUS_UNSPECIFIED": 0,
		"ACTIVE":                    1,
		"FIXED":                     2,
		"DISMISSED":                 3,
	}
)

func (x Report_ReportStatus) Enum() *Report_ReportStatus {
	p := new(Report_ReportStatus)
	*p = x
	return p
}

func (x Report_ReportStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Report_ReportStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_enumTypes[3].Descriptor()
}

func (Report_ReportStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_enumTypes[3]
}

func (x Report_ReportStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Report_ReportStatus.Descriptor instead.
func (Report_ReportStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_rawDescGZIP(), []int{0, 2}
}

// Groups of an report.
type Report_ReportGroup int32

const (
	Report_CATEGORY_UNSPECIFIED Report_ReportGroup = 0
	Report_VPC_NETWORK          Report_ReportGroup = 1
	Report_NETWORK_SERVICES     Report_ReportGroup = 2
	Report_KUBERNETES_ENGINE    Report_ReportGroup = 3
	Report_HYBRID_CONNECTIVITY  Report_ReportGroup = 4
	Report_MANAGED_SERVICES     Report_ReportGroup = 5
)

// Enum value maps for Report_ReportGroup.
var (
	Report_ReportGroup_name = map[int32]string{
		0: "CATEGORY_UNSPECIFIED",
		1: "VPC_NETWORK",
		2: "NETWORK_SERVICES",
		3: "KUBERNETES_ENGINE",
		4: "HYBRID_CONNECTIVITY",
		5: "MANAGED_SERVICES",
	}
	Report_ReportGroup_value = map[string]int32{
		"CATEGORY_UNSPECIFIED": 0,
		"VPC_NETWORK":          1,
		"NETWORK_SERVICES":     2,
		"KUBERNETES_ENGINE":    3,
		"HYBRID_CONNECTIVITY":  4,
		"MANAGED_SERVICES":     5,
	}
)

func (x Report_ReportGroup) Enum() *Report_ReportGroup {
	p := new(Report_ReportGroup)
	*p = x
	return p
}

func (x Report_ReportGroup) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Report_ReportGroup) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_enumTypes[4].Descriptor()
}

func (Report_ReportGroup) Type() protoreflect.EnumType {
	return &file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_enumTypes[4]
}

func (x Report_ReportGroup) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Report_ReportGroup.Descriptor instead.
func (Report_ReportGroup) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_rawDescGZIP(), []int{0, 3}
}

// Log entry that describes a report from Network Analyzer.
type Report struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the report.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Priority of the report.
	Priority Report_Priority `protobuf:"varint,2,opt,name=priority,proto3,enum=google.cloud.networkanalyzer.logging.v1.Report_Priority" json:"priority,omitempty"`
	// Type of the report.
	Type Report_Type `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.networkanalyzer.logging.v1.Report_Type" json:"type,omitempty"`
	// Status of the report.
	Status Report_ReportStatus `protobuf:"varint,4,opt,name=status,proto3,enum=google.cloud.networkanalyzer.logging.v1.Report_ReportStatus" json:"status,omitempty"`
	// The timestamp when the report was first discovered by Network Analyzer.
	FirstReportTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=first_report_time,json=firstReportTime,proto3" json:"first_report_time,omitempty"`
	// Cause code of the report.
	CauseCode ReportCauseCode `protobuf:"varint,12,opt,name=cause_code,json=causeCode,proto3,enum=google.cloud.networkanalyzer.logging.v1.ReportCauseCode" json:"cause_code,omitempty"`
	// The resource that are reported with the report.
	// Contains the fully qualified resource name.
	// e.g.,
	// `//compute.googleapis.com/projects/{project_id}/global/networks/{network}`
	ResourceName string `protobuf:"bytes,15,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Location associated with the report. It can be global or GCP regions
	// and zones. e.g., https://cloud.google.com/compute/docs/regions-zones/
	Location string `protobuf:"bytes,16,opt,name=location,proto3" json:"location,omitempty"`
	// URI to the documentation of the report.
	ReportDocumentationUri string `protobuf:"bytes,17,opt,name=report_documentation_uri,json=reportDocumentationUri,proto3" json:"report_documentation_uri,omitempty"`
	// The groups of the report. One report may be present in multiple groups.
	ReportGroups []Report_ReportGroup `protobuf:"varint,18,rep,packed,name=report_groups,json=reportGroups,proto3,enum=google.cloud.networkanalyzer.logging.v1.Report_ReportGroup" json:"report_groups,omitempty"`
}

func (x *Report) Reset() {
	*x = Report{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Report) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Report) ProtoMessage() {}

func (x *Report) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Report.ProtoReflect.Descriptor instead.
func (*Report) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_rawDescGZIP(), []int{0}
}

func (x *Report) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Report) GetPriority() Report_Priority {
	if x != nil {
		return x.Priority
	}
	return Report_SEVERITY_UNSPECIFIED
}

func (x *Report) GetType() Report_Type {
	if x != nil {
		return x.Type
	}
	return Report_REPORT_TYPE_UNSPECIFIED
}

func (x *Report) GetStatus() Report_ReportStatus {
	if x != nil {
		return x.Status
	}
	return Report_REPORT_STATUS_UNSPECIFIED
}

func (x *Report) GetFirstReportTime() *timestamppb.Timestamp {
	if x != nil {
		return x.FirstReportTime
	}
	return nil
}

func (x *Report) GetCauseCode() ReportCauseCode {
	if x != nil {
		return x.CauseCode
	}
	return ReportCauseCode_REPORT_CAUSE_CODE_UNSPECIFIED
}

func (x *Report) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *Report) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *Report) GetReportDocumentationUri() string {
	if x != nil {
		return x.ReportDocumentationUri
	}
	return ""
}

func (x *Report) GetReportGroups() []Report_ReportGroup {
	if x != nil {
		return x.ReportGroups
	}
	return nil
}

var File_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto protoreflect.FileDescriptor

var file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_rawDesc = []byte{
	0x0a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x2f, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x72, 0x5f, 0x6c, 0x6f, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x27, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x92, 0x08, 0x0a, 0x06, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x54, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x2e, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x70,
	0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x48, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x54, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72,
	0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x46, 0x0a, 0x11, 0x66, 0x69, 0x72, 0x73, 0x74,
	0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0f,
	0x66, 0x69, 0x72, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x57, 0x0a, 0x0a, 0x63, 0x61, 0x75, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x43, 0x61, 0x75, 0x73, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x09, 0x63,
	0x61, 0x75, 0x73, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x18, 0x72, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16, 0x72, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x55, 0x72, 0x69, 0x12, 0x60, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x18, 0x12, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x22, 0x51, 0x0a, 0x08, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43,
	0x52, 0x49, 0x54, 0x49, 0x43, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x49, 0x47,
	0x48, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x03, 0x12,
	0x07, 0x0a, 0x03, 0x4c, 0x4f, 0x57, 0x10, 0x04, 0x22, 0x45, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1b, 0x0a, 0x17, 0x52, 0x45, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x52, 0x4e, 0x49,
	0x4e, 0x47, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x22,
	0x53, 0x0a, 0x0c, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x1d, 0x0a, 0x19, 0x52, 0x45, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x46, 0x49,
	0x58, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x49, 0x53, 0x4d, 0x49, 0x53, 0x53,
	0x45, 0x44, 0x10, 0x03, 0x22, 0x94, 0x01, 0x0a, 0x0b, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x18, 0x0a, 0x14, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f,
	0x0a, 0x0b, 0x56, 0x50, 0x43, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x01, 0x12,
	0x14, 0x0a, 0x10, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49,
	0x43, 0x45, 0x53, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x4b, 0x55, 0x42, 0x45, 0x52, 0x4e, 0x45,
	0x54, 0x45, 0x53, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x10, 0x03, 0x12, 0x17, 0x0a, 0x13,
	0x48, 0x59, 0x42, 0x52, 0x49, 0x44, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x56,
	0x49, 0x54, 0x59, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44,
	0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x53, 0x10, 0x05, 0x2a, 0xca, 0x0d, 0x0a, 0x0f,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x61, 0x75, 0x73, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x21, 0x0a, 0x1d, 0x52, 0x45, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x43, 0x41, 0x55, 0x53, 0x45, 0x5f,
	0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x34, 0x0a, 0x30, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x49, 0x4e, 0x56, 0x41,
	0x4c, 0x49, 0x44, 0x5f, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x56, 0x4d, 0x5f,
	0x49, 0x50, 0x5f, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x44, 0x49,
	0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x25, 0x0a, 0x21, 0x52, 0x4f, 0x55, 0x54,
	0x45, 0x5f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48,
	0x4f, 0x50, 0x5f, 0x56, 0x4d, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x25, 0x0a, 0x21, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44,
	0x5f, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x56, 0x4d, 0x5f, 0x53, 0x54, 0x4f,
	0x50, 0x50, 0x45, 0x44, 0x10, 0x03, 0x12, 0x2c, 0x0a, 0x28, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f,
	0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50,
	0x5f, 0x49, 0x4c, 0x42, 0x5f, 0x4d, 0x49, 0x53, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x55, 0x52,
	0x45, 0x44, 0x10, 0x04, 0x12, 0x2d, 0x0a, 0x29, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x49, 0x4e,
	0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x56,
	0x50, 0x4e, 0x5f, 0x54, 0x55, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45,
	0x44, 0x10, 0x05, 0x12, 0x3d, 0x0a, 0x39, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x49, 0x4e, 0x56,
	0x41, 0x4c, 0x49, 0x44, 0x5f, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x49, 0x4c,
	0x42, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x45, 0x4e, 0x44, 0x5f, 0x49, 0x50, 0x5f, 0x46, 0x4f, 0x52,
	0x57, 0x41, 0x52, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44,
	0x10, 0x06, 0x12, 0x2b, 0x0a, 0x27, 0x49, 0x50, 0x5f, 0x55, 0x54, 0x49, 0x4c, 0x49, 0x5a, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x50, 0x5f, 0x41, 0x4c, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0x14, 0x12,
	0x37, 0x0a, 0x32, 0x47, 0x4b, 0x45, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x54, 0x4f, 0x5f, 0x43,
	0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x5f, 0x50, 0x4c, 0x41, 0x4e, 0x45, 0x5f, 0x42, 0x4c, 0x4f,
	0x43, 0x4b, 0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x49, 0x4e, 0x47, 0x5f,
	0x49, 0x53, 0x53, 0x55, 0x45, 0x10, 0xc9, 0x01, 0x12, 0x49, 0x0a, 0x44, 0x47, 0x4b, 0x45, 0x5f,
	0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x54, 0x4f, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x5f,
	0x50, 0x4c, 0x41, 0x4e, 0x45, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x5f, 0x45, 0x4e, 0x44,
	0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x45, 0x44, 0x5f, 0x42, 0x59,
	0x5f, 0x45, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c,
	0x10, 0xca, 0x01, 0x12, 0x4a, 0x0a, 0x45, 0x47, 0x4b, 0x45, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x5f,
	0x54, 0x4f, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x5f, 0x50, 0x4c, 0x41, 0x4e, 0x45,
	0x5f, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x45, 0x4e, 0x44, 0x50, 0x4f, 0x49, 0x4e,
	0x54, 0x5f, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x45, 0x47, 0x52,
	0x45, 0x53, 0x53, 0x5f, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x10, 0xcb, 0x01, 0x12,
	0x37, 0x0a, 0x32, 0x47, 0x4b, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x5f, 0x50,
	0x4c, 0x41, 0x4e, 0x45, 0x5f, 0x54, 0x4f, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x42, 0x4c, 0x4f,
	0x43, 0x4b, 0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x49, 0x4e, 0x47, 0x5f,
	0x49, 0x53, 0x53, 0x55, 0x45, 0x10, 0xd3, 0x01, 0x12, 0x42, 0x0a, 0x3d, 0x47, 0x4b, 0x45, 0x5f,
	0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x5f, 0x50, 0x4c, 0x41, 0x4e, 0x45, 0x5f, 0x54, 0x4f,
	0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x45, 0x44, 0x5f, 0x42, 0x59,
	0x5f, 0x49, 0x4e, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c,
	0x4c, 0x5f, 0x4f, 0x4e, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x10, 0xd4, 0x01, 0x12, 0x32, 0x0a, 0x2d,
	0x47, 0x4b, 0x45, 0x5f, 0x49, 0x50, 0x5f, 0x55, 0x54, 0x49, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x50, 0x4f, 0x44, 0x5f, 0x52, 0x41, 0x4e, 0x47, 0x45, 0x53, 0x5f, 0x41, 0x4c,
	0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0xdd, 0x01,
	0x12, 0x41, 0x0a, 0x3c, 0x47, 0x4b, 0x45, 0x5f, 0x49, 0x50, 0x5f, 0x55, 0x54, 0x49, 0x4c, 0x49,
	0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x4f, 0x44, 0x5f, 0x52, 0x41, 0x4e, 0x47, 0x45,
	0x53, 0x5f, 0x41, 0x4c, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4c, 0x49, 0x4d,
	0x49, 0x54, 0x45, 0x53, 0x5f, 0x41, 0x55, 0x54, 0x4f, 0x53, 0x43, 0x41, 0x4c, 0x49, 0x4e, 0x47,
	0x10, 0xde, 0x01, 0x12, 0x34, 0x0a, 0x2f, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x51, 0x4c,
	0x5f, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x49, 0x50, 0x5f, 0x42, 0x4c, 0x4f, 0x43,
	0x4b, 0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x45, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x46, 0x49,
	0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x10, 0xd9, 0x04, 0x12, 0x32, 0x0a, 0x2d, 0x43, 0x4c, 0x4f,
	0x55, 0x44, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x49,
	0x50, 0x5f, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x52, 0x4f, 0x55,
	0x54, 0x49, 0x4e, 0x47, 0x5f, 0x49, 0x53, 0x53, 0x55, 0x45, 0x10, 0xda, 0x04, 0x12, 0x2e, 0x0a,
	0x29, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x50, 0x52, 0x49, 0x56, 0x41,
	0x54, 0x45, 0x5f, 0x49, 0x50, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x4e,
	0x4f, 0x54, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0xdb, 0x04, 0x12, 0x3a, 0x0a,
	0x35, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x53,
	0x48, 0x41, 0x44, 0x4f, 0x57, 0x45, 0x44, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x59, 0x5f, 0x53, 0x48,
	0x41, 0x44, 0x4f, 0x57, 0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x53, 0x55, 0x42, 0x4e, 0x45, 0x54,
	0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x10, 0xa1, 0x06, 0x12, 0x42, 0x0a, 0x3d, 0x44, 0x59, 0x4e,
	0x41, 0x4d, 0x49, 0x43, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x53, 0x48, 0x41, 0x44, 0x4f,
	0x57, 0x45, 0x44, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x59, 0x5f, 0x53, 0x48, 0x41, 0x44, 0x4f, 0x57,
	0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x55,
	0x42, 0x4e, 0x45, 0x54, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x10, 0xa2, 0x06, 0x12, 0x3a, 0x0a,
	0x35, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x53,
	0x48, 0x41, 0x44, 0x4f, 0x57, 0x45, 0x44, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x59, 0x5f, 0x53, 0x48,
	0x41, 0x44, 0x4f, 0x57, 0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x49, 0x43,
	0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x10, 0xa3, 0x06, 0x12, 0x42, 0x0a, 0x3d, 0x44, 0x59, 0x4e,
	0x41, 0x4d, 0x49, 0x43, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x53, 0x48, 0x41, 0x44, 0x4f,
	0x57, 0x45, 0x44, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x59, 0x5f, 0x53, 0x48, 0x41, 0x44, 0x4f, 0x57,
	0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54,
	0x41, 0x54, 0x49, 0x43, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x10, 0xa4, 0x06, 0x12, 0x3e, 0x0a,
	0x39, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x53,
	0x48, 0x41, 0x44, 0x4f, 0x57, 0x45, 0x44, 0x5f, 0x50, 0x41, 0x52, 0x54, 0x49, 0x41, 0x4c, 0x4c,
	0x59, 0x5f, 0x53, 0x48, 0x41, 0x44, 0x4f, 0x57, 0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x53, 0x55,
	0x42, 0x4e, 0x45, 0x54, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x10, 0xa5, 0x06, 0x12, 0x46, 0x0a,
	0x41, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x53,
	0x48, 0x41, 0x44, 0x4f, 0x57, 0x45, 0x44, 0x5f, 0x50, 0x41, 0x52, 0x54, 0x49, 0x41, 0x4c, 0x4c,
	0x59, 0x5f, 0x53, 0x48, 0x41, 0x44, 0x4f, 0x57, 0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x50, 0x45,
	0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x55, 0x42, 0x4e, 0x45, 0x54, 0x5f, 0x52, 0x4f, 0x55,
	0x54, 0x45, 0x10, 0xa6, 0x06, 0x12, 0x3e, 0x0a, 0x39, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43,
	0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x53, 0x48, 0x41, 0x44, 0x4f, 0x57, 0x45, 0x44, 0x5f,
	0x50, 0x41, 0x52, 0x54, 0x49, 0x41, 0x4c, 0x4c, 0x59, 0x5f, 0x53, 0x48, 0x41, 0x44, 0x4f, 0x57,
	0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x49, 0x43, 0x5f, 0x52, 0x4f, 0x55,
	0x54, 0x45, 0x10, 0xa7, 0x06, 0x12, 0x46, 0x0a, 0x41, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43,
	0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x53, 0x48, 0x41, 0x44, 0x4f, 0x57, 0x45, 0x44, 0x5f,
	0x50, 0x41, 0x52, 0x54, 0x49, 0x41, 0x4c, 0x4c, 0x59, 0x5f, 0x53, 0x48, 0x41, 0x44, 0x4f, 0x57,
	0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54,
	0x41, 0x54, 0x49, 0x43, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x10, 0xa8, 0x06, 0x12, 0x4d, 0x0a,
	0x48, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52, 0x5f, 0x48,
	0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x5f, 0x46, 0x49, 0x52, 0x45,
	0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x43, 0x48, 0x45, 0x43,
	0x4b, 0x5f, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x43,
	0x4f, 0x4e, 0x46, 0x49, 0x47, 0x55, 0x52, 0x45, 0x44, 0x10, 0xe9, 0x07, 0x12, 0x43, 0x0a, 0x3e,
	0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52, 0x5f, 0x48, 0x45,
	0x41, 0x4c, 0x54, 0x48, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x5f, 0x46, 0x49, 0x52, 0x45, 0x57,
	0x41, 0x4c, 0x4c, 0x5f, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b,
	0x5f, 0x52, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x45, 0x44, 0x10, 0xea,
	0x07, 0x12, 0x45, 0x0a, 0x40, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43,
	0x45, 0x52, 0x5f, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x5f,
	0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c,
	0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x49, 0x4e, 0x43, 0x4f, 0x4e, 0x53, 0x49,
	0x53, 0x54, 0x45, 0x4e, 0x54, 0x10, 0xeb, 0x07, 0x42, 0x93, 0x02, 0x0a, 0x2b, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x2e, 0x6c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x72, 0x4c, 0x6f, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x2f, 0x76, 0x31, 0x3b, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0xaa, 0x02, 0x27, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x2e, 0x4c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x72, 0x5c, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x72, 0x3a, 0x3a, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_rawDescOnce sync.Once
	file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_rawDescData = file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_rawDesc
)

func file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_rawDescGZIP() []byte {
	file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_rawDescOnce.Do(func() {
		file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_rawDescData)
	})
	return file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_rawDescData
}

var file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_goTypes = []interface{}{
	(ReportCauseCode)(0),          // 0: google.cloud.networkanalyzer.logging.v1.ReportCauseCode
	(Report_Priority)(0),          // 1: google.cloud.networkanalyzer.logging.v1.Report.Priority
	(Report_Type)(0),              // 2: google.cloud.networkanalyzer.logging.v1.Report.Type
	(Report_ReportStatus)(0),      // 3: google.cloud.networkanalyzer.logging.v1.Report.ReportStatus
	(Report_ReportGroup)(0),       // 4: google.cloud.networkanalyzer.logging.v1.Report.ReportGroup
	(*Report)(nil),                // 5: google.cloud.networkanalyzer.logging.v1.Report
	(*timestamppb.Timestamp)(nil), // 6: google.protobuf.Timestamp
}
var file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_depIdxs = []int32{
	1, // 0: google.cloud.networkanalyzer.logging.v1.Report.priority:type_name -> google.cloud.networkanalyzer.logging.v1.Report.Priority
	2, // 1: google.cloud.networkanalyzer.logging.v1.Report.type:type_name -> google.cloud.networkanalyzer.logging.v1.Report.Type
	3, // 2: google.cloud.networkanalyzer.logging.v1.Report.status:type_name -> google.cloud.networkanalyzer.logging.v1.Report.ReportStatus
	6, // 3: google.cloud.networkanalyzer.logging.v1.Report.first_report_time:type_name -> google.protobuf.Timestamp
	0, // 4: google.cloud.networkanalyzer.logging.v1.Report.cause_code:type_name -> google.cloud.networkanalyzer.logging.v1.ReportCauseCode
	4, // 5: google.cloud.networkanalyzer.logging.v1.Report.report_groups:type_name -> google.cloud.networkanalyzer.logging.v1.Report.ReportGroup
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_init() }
func file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_init() {
	if File_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Report); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_goTypes,
		DependencyIndexes: file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_depIdxs,
		EnumInfos:         file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_enumTypes,
		MessageInfos:      file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_msgTypes,
	}.Build()
	File_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto = out.File
	file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_rawDesc = nil
	file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_goTypes = nil
	file_google_cloud_networkanalyzer_logging_v1_analyzer_log_proto_depIdxs = nil
}
