// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/datalabeling/v1beta1/operations.proto

package datalabelingpb

import (
	reflect "reflect"
	sync "sync"

	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Response used for ImportData longrunning operation.
type ImportDataOperationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Ouptut only. The name of imported dataset.
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Output only. Total number of examples requested to import
	TotalCount int32 `protobuf:"varint,2,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
	// Output only. Number of examples imported successfully.
	ImportCount int32 `protobuf:"varint,3,opt,name=import_count,json=importCount,proto3" json:"import_count,omitempty"`
}

func (x *ImportDataOperationResponse) Reset() {
	*x = ImportDataOperationResponse{}
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportDataOperationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDataOperationResponse) ProtoMessage() {}

func (x *ImportDataOperationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDataOperationResponse.ProtoReflect.Descriptor instead.
func (*ImportDataOperationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescGZIP(), []int{0}
}

func (x *ImportDataOperationResponse) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *ImportDataOperationResponse) GetTotalCount() int32 {
	if x != nil {
		return x.TotalCount
	}
	return 0
}

func (x *ImportDataOperationResponse) GetImportCount() int32 {
	if x != nil {
		return x.ImportCount
	}
	return 0
}

// Response used for ExportDataset longrunning operation.
type ExportDataOperationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Ouptut only. The name of dataset.
	// "projects/*/datasets/*"
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Output only. Total number of examples requested to export
	TotalCount int32 `protobuf:"varint,2,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
	// Output only. Number of examples exported successfully.
	ExportCount int32 `protobuf:"varint,3,opt,name=export_count,json=exportCount,proto3" json:"export_count,omitempty"`
	// Output only. Statistic infos of labels in the exported dataset.
	LabelStats *LabelStats `protobuf:"bytes,4,opt,name=label_stats,json=labelStats,proto3" json:"label_stats,omitempty"`
	// Output only. output_config in the ExportData request.
	OutputConfig *OutputConfig `protobuf:"bytes,5,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
}

func (x *ExportDataOperationResponse) Reset() {
	*x = ExportDataOperationResponse{}
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportDataOperationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportDataOperationResponse) ProtoMessage() {}

func (x *ExportDataOperationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportDataOperationResponse.ProtoReflect.Descriptor instead.
func (*ExportDataOperationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescGZIP(), []int{1}
}

func (x *ExportDataOperationResponse) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *ExportDataOperationResponse) GetTotalCount() int32 {
	if x != nil {
		return x.TotalCount
	}
	return 0
}

func (x *ExportDataOperationResponse) GetExportCount() int32 {
	if x != nil {
		return x.ExportCount
	}
	return 0
}

func (x *ExportDataOperationResponse) GetLabelStats() *LabelStats {
	if x != nil {
		return x.LabelStats
	}
	return nil
}

func (x *ExportDataOperationResponse) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

// Metadata of an ImportData operation.
type ImportDataOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of imported dataset.
	// "projects/*/datasets/*"
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Output only. Partial failures encountered.
	// E.g. single files that couldn't be read.
	// Status details field will contain standard GCP error details.
	PartialFailures []*status.Status `protobuf:"bytes,2,rep,name=partial_failures,json=partialFailures,proto3" json:"partial_failures,omitempty"`
	// Output only. Timestamp when import dataset request was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *ImportDataOperationMetadata) Reset() {
	*x = ImportDataOperationMetadata{}
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportDataOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDataOperationMetadata) ProtoMessage() {}

func (x *ImportDataOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDataOperationMetadata.ProtoReflect.Descriptor instead.
func (*ImportDataOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescGZIP(), []int{2}
}

func (x *ImportDataOperationMetadata) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *ImportDataOperationMetadata) GetPartialFailures() []*status.Status {
	if x != nil {
		return x.PartialFailures
	}
	return nil
}

func (x *ImportDataOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Metadata of an ExportData operation.
type ExportDataOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of dataset to be exported.
	// "projects/*/datasets/*"
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Output only. Partial failures encountered.
	// E.g. single files that couldn't be read.
	// Status details field will contain standard GCP error details.
	PartialFailures []*status.Status `protobuf:"bytes,2,rep,name=partial_failures,json=partialFailures,proto3" json:"partial_failures,omitempty"`
	// Output only. Timestamp when export dataset request was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *ExportDataOperationMetadata) Reset() {
	*x = ExportDataOperationMetadata{}
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportDataOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportDataOperationMetadata) ProtoMessage() {}

func (x *ExportDataOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportDataOperationMetadata.ProtoReflect.Descriptor instead.
func (*ExportDataOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescGZIP(), []int{3}
}

func (x *ExportDataOperationMetadata) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *ExportDataOperationMetadata) GetPartialFailures() []*status.Status {
	if x != nil {
		return x.PartialFailures
	}
	return nil
}

func (x *ExportDataOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Metadata of a labeling operation, such as LabelImage or LabelVideo.
// Next tag: 20
type LabelOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Ouptut only. Details of specific label operation.
	//
	// Types that are assignable to Details:
	//
	//	*LabelOperationMetadata_ImageClassificationDetails
	//	*LabelOperationMetadata_ImageBoundingBoxDetails
	//	*LabelOperationMetadata_ImageBoundingPolyDetails
	//	*LabelOperationMetadata_ImageOrientedBoundingBoxDetails
	//	*LabelOperationMetadata_ImagePolylineDetails
	//	*LabelOperationMetadata_ImageSegmentationDetails
	//	*LabelOperationMetadata_VideoClassificationDetails
	//	*LabelOperationMetadata_VideoObjectDetectionDetails
	//	*LabelOperationMetadata_VideoObjectTrackingDetails
	//	*LabelOperationMetadata_VideoEventDetails
	//	*LabelOperationMetadata_TextClassificationDetails
	//	*LabelOperationMetadata_TextEntityExtractionDetails
	Details isLabelOperationMetadata_Details `protobuf_oneof:"details"`
	// Output only. Progress of label operation. Range: [0, 100].
	ProgressPercent int32 `protobuf:"varint,1,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Output only. Partial failures encountered.
	// E.g. single files that couldn't be read.
	// Status details field will contain standard GCP error details.
	PartialFailures []*status.Status `protobuf:"bytes,2,rep,name=partial_failures,json=partialFailures,proto3" json:"partial_failures,omitempty"`
	// Output only. Timestamp when labeling request was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,16,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *LabelOperationMetadata) Reset() {
	*x = LabelOperationMetadata{}
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelOperationMetadata) ProtoMessage() {}

func (x *LabelOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelOperationMetadata.ProtoReflect.Descriptor instead.
func (*LabelOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescGZIP(), []int{4}
}

func (m *LabelOperationMetadata) GetDetails() isLabelOperationMetadata_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *LabelOperationMetadata) GetImageClassificationDetails() *LabelImageClassificationOperationMetadata {
	if x, ok := x.GetDetails().(*LabelOperationMetadata_ImageClassificationDetails); ok {
		return x.ImageClassificationDetails
	}
	return nil
}

func (x *LabelOperationMetadata) GetImageBoundingBoxDetails() *LabelImageBoundingBoxOperationMetadata {
	if x, ok := x.GetDetails().(*LabelOperationMetadata_ImageBoundingBoxDetails); ok {
		return x.ImageBoundingBoxDetails
	}
	return nil
}

func (x *LabelOperationMetadata) GetImageBoundingPolyDetails() *LabelImageBoundingPolyOperationMetadata {
	if x, ok := x.GetDetails().(*LabelOperationMetadata_ImageBoundingPolyDetails); ok {
		return x.ImageBoundingPolyDetails
	}
	return nil
}

func (x *LabelOperationMetadata) GetImageOrientedBoundingBoxDetails() *LabelImageOrientedBoundingBoxOperationMetadata {
	if x, ok := x.GetDetails().(*LabelOperationMetadata_ImageOrientedBoundingBoxDetails); ok {
		return x.ImageOrientedBoundingBoxDetails
	}
	return nil
}

func (x *LabelOperationMetadata) GetImagePolylineDetails() *LabelImagePolylineOperationMetadata {
	if x, ok := x.GetDetails().(*LabelOperationMetadata_ImagePolylineDetails); ok {
		return x.ImagePolylineDetails
	}
	return nil
}

func (x *LabelOperationMetadata) GetImageSegmentationDetails() *LabelImageSegmentationOperationMetadata {
	if x, ok := x.GetDetails().(*LabelOperationMetadata_ImageSegmentationDetails); ok {
		return x.ImageSegmentationDetails
	}
	return nil
}

func (x *LabelOperationMetadata) GetVideoClassificationDetails() *LabelVideoClassificationOperationMetadata {
	if x, ok := x.GetDetails().(*LabelOperationMetadata_VideoClassificationDetails); ok {
		return x.VideoClassificationDetails
	}
	return nil
}

func (x *LabelOperationMetadata) GetVideoObjectDetectionDetails() *LabelVideoObjectDetectionOperationMetadata {
	if x, ok := x.GetDetails().(*LabelOperationMetadata_VideoObjectDetectionDetails); ok {
		return x.VideoObjectDetectionDetails
	}
	return nil
}

func (x *LabelOperationMetadata) GetVideoObjectTrackingDetails() *LabelVideoObjectTrackingOperationMetadata {
	if x, ok := x.GetDetails().(*LabelOperationMetadata_VideoObjectTrackingDetails); ok {
		return x.VideoObjectTrackingDetails
	}
	return nil
}

func (x *LabelOperationMetadata) GetVideoEventDetails() *LabelVideoEventOperationMetadata {
	if x, ok := x.GetDetails().(*LabelOperationMetadata_VideoEventDetails); ok {
		return x.VideoEventDetails
	}
	return nil
}

func (x *LabelOperationMetadata) GetTextClassificationDetails() *LabelTextClassificationOperationMetadata {
	if x, ok := x.GetDetails().(*LabelOperationMetadata_TextClassificationDetails); ok {
		return x.TextClassificationDetails
	}
	return nil
}

func (x *LabelOperationMetadata) GetTextEntityExtractionDetails() *LabelTextEntityExtractionOperationMetadata {
	if x, ok := x.GetDetails().(*LabelOperationMetadata_TextEntityExtractionDetails); ok {
		return x.TextEntityExtractionDetails
	}
	return nil
}

func (x *LabelOperationMetadata) GetProgressPercent() int32 {
	if x != nil {
		return x.ProgressPercent
	}
	return 0
}

func (x *LabelOperationMetadata) GetPartialFailures() []*status.Status {
	if x != nil {
		return x.PartialFailures
	}
	return nil
}

func (x *LabelOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

type isLabelOperationMetadata_Details interface {
	isLabelOperationMetadata_Details()
}

type LabelOperationMetadata_ImageClassificationDetails struct {
	// Details of label image classification operation.
	ImageClassificationDetails *LabelImageClassificationOperationMetadata `protobuf:"bytes,3,opt,name=image_classification_details,json=imageClassificationDetails,proto3,oneof"`
}

type LabelOperationMetadata_ImageBoundingBoxDetails struct {
	// Details of label image bounding box operation.
	ImageBoundingBoxDetails *LabelImageBoundingBoxOperationMetadata `protobuf:"bytes,4,opt,name=image_bounding_box_details,json=imageBoundingBoxDetails,proto3,oneof"`
}

type LabelOperationMetadata_ImageBoundingPolyDetails struct {
	// Details of label image bounding poly operation.
	ImageBoundingPolyDetails *LabelImageBoundingPolyOperationMetadata `protobuf:"bytes,11,opt,name=image_bounding_poly_details,json=imageBoundingPolyDetails,proto3,oneof"`
}

type LabelOperationMetadata_ImageOrientedBoundingBoxDetails struct {
	// Details of label image oriented bounding box operation.
	ImageOrientedBoundingBoxDetails *LabelImageOrientedBoundingBoxOperationMetadata `protobuf:"bytes,14,opt,name=image_oriented_bounding_box_details,json=imageOrientedBoundingBoxDetails,proto3,oneof"`
}

type LabelOperationMetadata_ImagePolylineDetails struct {
	// Details of label image polyline operation.
	ImagePolylineDetails *LabelImagePolylineOperationMetadata `protobuf:"bytes,12,opt,name=image_polyline_details,json=imagePolylineDetails,proto3,oneof"`
}

type LabelOperationMetadata_ImageSegmentationDetails struct {
	// Details of label image segmentation operation.
	ImageSegmentationDetails *LabelImageSegmentationOperationMetadata `protobuf:"bytes,15,opt,name=image_segmentation_details,json=imageSegmentationDetails,proto3,oneof"`
}

type LabelOperationMetadata_VideoClassificationDetails struct {
	// Details of label video classification operation.
	VideoClassificationDetails *LabelVideoClassificationOperationMetadata `protobuf:"bytes,5,opt,name=video_classification_details,json=videoClassificationDetails,proto3,oneof"`
}

type LabelOperationMetadata_VideoObjectDetectionDetails struct {
	// Details of label video object detection operation.
	VideoObjectDetectionDetails *LabelVideoObjectDetectionOperationMetadata `protobuf:"bytes,6,opt,name=video_object_detection_details,json=videoObjectDetectionDetails,proto3,oneof"`
}

type LabelOperationMetadata_VideoObjectTrackingDetails struct {
	// Details of label video object tracking operation.
	VideoObjectTrackingDetails *LabelVideoObjectTrackingOperationMetadata `protobuf:"bytes,7,opt,name=video_object_tracking_details,json=videoObjectTrackingDetails,proto3,oneof"`
}

type LabelOperationMetadata_VideoEventDetails struct {
	// Details of label video event operation.
	VideoEventDetails *LabelVideoEventOperationMetadata `protobuf:"bytes,8,opt,name=video_event_details,json=videoEventDetails,proto3,oneof"`
}

type LabelOperationMetadata_TextClassificationDetails struct {
	// Details of label text classification operation.
	TextClassificationDetails *LabelTextClassificationOperationMetadata `protobuf:"bytes,9,opt,name=text_classification_details,json=textClassificationDetails,proto3,oneof"`
}

type LabelOperationMetadata_TextEntityExtractionDetails struct {
	// Details of label text entity extraction operation.
	TextEntityExtractionDetails *LabelTextEntityExtractionOperationMetadata `protobuf:"bytes,13,opt,name=text_entity_extraction_details,json=textEntityExtractionDetails,proto3,oneof"`
}

func (*LabelOperationMetadata_ImageClassificationDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_ImageBoundingBoxDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_ImageBoundingPolyDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_ImageOrientedBoundingBoxDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_ImagePolylineDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_ImageSegmentationDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_VideoClassificationDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_VideoObjectDetectionDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_VideoObjectTrackingDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_VideoEventDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_TextClassificationDetails) isLabelOperationMetadata_Details() {}

func (*LabelOperationMetadata_TextEntityExtractionDetails) isLabelOperationMetadata_Details() {}

// Metadata of a LabelImageClassification operation.
type LabelImageClassificationOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Basic human annotation config used in labeling request.
	BasicConfig *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
}

func (x *LabelImageClassificationOperationMetadata) Reset() {
	*x = LabelImageClassificationOperationMetadata{}
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelImageClassificationOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelImageClassificationOperationMetadata) ProtoMessage() {}

func (x *LabelImageClassificationOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelImageClassificationOperationMetadata.ProtoReflect.Descriptor instead.
func (*LabelImageClassificationOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescGZIP(), []int{5}
}

func (x *LabelImageClassificationOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if x != nil {
		return x.BasicConfig
	}
	return nil
}

// Details of a LabelImageBoundingBox operation metadata.
type LabelImageBoundingBoxOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Basic human annotation config used in labeling request.
	BasicConfig *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
}

func (x *LabelImageBoundingBoxOperationMetadata) Reset() {
	*x = LabelImageBoundingBoxOperationMetadata{}
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelImageBoundingBoxOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelImageBoundingBoxOperationMetadata) ProtoMessage() {}

func (x *LabelImageBoundingBoxOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelImageBoundingBoxOperationMetadata.ProtoReflect.Descriptor instead.
func (*LabelImageBoundingBoxOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescGZIP(), []int{6}
}

func (x *LabelImageBoundingBoxOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if x != nil {
		return x.BasicConfig
	}
	return nil
}

// Details of a LabelImageOrientedBoundingBox operation metadata.
type LabelImageOrientedBoundingBoxOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Basic human annotation config.
	BasicConfig *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
}

func (x *LabelImageOrientedBoundingBoxOperationMetadata) Reset() {
	*x = LabelImageOrientedBoundingBoxOperationMetadata{}
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelImageOrientedBoundingBoxOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelImageOrientedBoundingBoxOperationMetadata) ProtoMessage() {}

func (x *LabelImageOrientedBoundingBoxOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelImageOrientedBoundingBoxOperationMetadata.ProtoReflect.Descriptor instead.
func (*LabelImageOrientedBoundingBoxOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescGZIP(), []int{7}
}

func (x *LabelImageOrientedBoundingBoxOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if x != nil {
		return x.BasicConfig
	}
	return nil
}

// Details of LabelImageBoundingPoly operation metadata.
type LabelImageBoundingPolyOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Basic human annotation config used in labeling request.
	BasicConfig *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
}

func (x *LabelImageBoundingPolyOperationMetadata) Reset() {
	*x = LabelImageBoundingPolyOperationMetadata{}
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelImageBoundingPolyOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelImageBoundingPolyOperationMetadata) ProtoMessage() {}

func (x *LabelImageBoundingPolyOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelImageBoundingPolyOperationMetadata.ProtoReflect.Descriptor instead.
func (*LabelImageBoundingPolyOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescGZIP(), []int{8}
}

func (x *LabelImageBoundingPolyOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if x != nil {
		return x.BasicConfig
	}
	return nil
}

// Details of LabelImagePolyline operation metadata.
type LabelImagePolylineOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Basic human annotation config used in labeling request.
	BasicConfig *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
}

func (x *LabelImagePolylineOperationMetadata) Reset() {
	*x = LabelImagePolylineOperationMetadata{}
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelImagePolylineOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelImagePolylineOperationMetadata) ProtoMessage() {}

func (x *LabelImagePolylineOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelImagePolylineOperationMetadata.ProtoReflect.Descriptor instead.
func (*LabelImagePolylineOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescGZIP(), []int{9}
}

func (x *LabelImagePolylineOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if x != nil {
		return x.BasicConfig
	}
	return nil
}

// Details of a LabelImageSegmentation operation metadata.
type LabelImageSegmentationOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Basic human annotation config.
	BasicConfig *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
}

func (x *LabelImageSegmentationOperationMetadata) Reset() {
	*x = LabelImageSegmentationOperationMetadata{}
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelImageSegmentationOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelImageSegmentationOperationMetadata) ProtoMessage() {}

func (x *LabelImageSegmentationOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelImageSegmentationOperationMetadata.ProtoReflect.Descriptor instead.
func (*LabelImageSegmentationOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescGZIP(), []int{10}
}

func (x *LabelImageSegmentationOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if x != nil {
		return x.BasicConfig
	}
	return nil
}

// Details of a LabelVideoClassification operation metadata.
type LabelVideoClassificationOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Basic human annotation config used in labeling request.
	BasicConfig *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
}

func (x *LabelVideoClassificationOperationMetadata) Reset() {
	*x = LabelVideoClassificationOperationMetadata{}
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelVideoClassificationOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelVideoClassificationOperationMetadata) ProtoMessage() {}

func (x *LabelVideoClassificationOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelVideoClassificationOperationMetadata.ProtoReflect.Descriptor instead.
func (*LabelVideoClassificationOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescGZIP(), []int{11}
}

func (x *LabelVideoClassificationOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if x != nil {
		return x.BasicConfig
	}
	return nil
}

// Details of a LabelVideoObjectDetection operation metadata.
type LabelVideoObjectDetectionOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Basic human annotation config used in labeling request.
	BasicConfig *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
}

func (x *LabelVideoObjectDetectionOperationMetadata) Reset() {
	*x = LabelVideoObjectDetectionOperationMetadata{}
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelVideoObjectDetectionOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelVideoObjectDetectionOperationMetadata) ProtoMessage() {}

func (x *LabelVideoObjectDetectionOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelVideoObjectDetectionOperationMetadata.ProtoReflect.Descriptor instead.
func (*LabelVideoObjectDetectionOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescGZIP(), []int{12}
}

func (x *LabelVideoObjectDetectionOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if x != nil {
		return x.BasicConfig
	}
	return nil
}

// Details of a LabelVideoObjectTracking operation metadata.
type LabelVideoObjectTrackingOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Basic human annotation config used in labeling request.
	BasicConfig *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
}

func (x *LabelVideoObjectTrackingOperationMetadata) Reset() {
	*x = LabelVideoObjectTrackingOperationMetadata{}
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelVideoObjectTrackingOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelVideoObjectTrackingOperationMetadata) ProtoMessage() {}

func (x *LabelVideoObjectTrackingOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelVideoObjectTrackingOperationMetadata.ProtoReflect.Descriptor instead.
func (*LabelVideoObjectTrackingOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescGZIP(), []int{13}
}

func (x *LabelVideoObjectTrackingOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if x != nil {
		return x.BasicConfig
	}
	return nil
}

// Details of a LabelVideoEvent operation metadata.
type LabelVideoEventOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Basic human annotation config used in labeling request.
	BasicConfig *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
}

func (x *LabelVideoEventOperationMetadata) Reset() {
	*x = LabelVideoEventOperationMetadata{}
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelVideoEventOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelVideoEventOperationMetadata) ProtoMessage() {}

func (x *LabelVideoEventOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelVideoEventOperationMetadata.ProtoReflect.Descriptor instead.
func (*LabelVideoEventOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescGZIP(), []int{14}
}

func (x *LabelVideoEventOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if x != nil {
		return x.BasicConfig
	}
	return nil
}

// Details of a LabelTextClassification operation metadata.
type LabelTextClassificationOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Basic human annotation config used in labeling request.
	BasicConfig *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
}

func (x *LabelTextClassificationOperationMetadata) Reset() {
	*x = LabelTextClassificationOperationMetadata{}
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelTextClassificationOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelTextClassificationOperationMetadata) ProtoMessage() {}

func (x *LabelTextClassificationOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelTextClassificationOperationMetadata.ProtoReflect.Descriptor instead.
func (*LabelTextClassificationOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescGZIP(), []int{15}
}

func (x *LabelTextClassificationOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if x != nil {
		return x.BasicConfig
	}
	return nil
}

// Details of a LabelTextEntityExtraction operation metadata.
type LabelTextEntityExtractionOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Basic human annotation config used in labeling request.
	BasicConfig *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
}

func (x *LabelTextEntityExtractionOperationMetadata) Reset() {
	*x = LabelTextEntityExtractionOperationMetadata{}
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelTextEntityExtractionOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelTextEntityExtractionOperationMetadata) ProtoMessage() {}

func (x *LabelTextEntityExtractionOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelTextEntityExtractionOperationMetadata.ProtoReflect.Descriptor instead.
func (*LabelTextEntityExtractionOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescGZIP(), []int{16}
}

func (x *LabelTextEntityExtractionOperationMetadata) GetBasicConfig() *HumanAnnotationConfig {
	if x != nil {
		return x.BasicConfig
	}
	return nil
}

// Metadata of a CreateInstruction operation.
type CreateInstructionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the created Instruction.
	// projects/{project_id}/instructions/{instruction_id}
	Instruction string `protobuf:"bytes,1,opt,name=instruction,proto3" json:"instruction,omitempty"`
	// Partial failures encountered.
	// E.g. single files that couldn't be read.
	// Status details field will contain standard GCP error details.
	PartialFailures []*status.Status `protobuf:"bytes,2,rep,name=partial_failures,json=partialFailures,proto3" json:"partial_failures,omitempty"`
	// Timestamp when create instruction request was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *CreateInstructionMetadata) Reset() {
	*x = CreateInstructionMetadata{}
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateInstructionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInstructionMetadata) ProtoMessage() {}

func (x *CreateInstructionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInstructionMetadata.ProtoReflect.Descriptor instead.
func (*CreateInstructionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescGZIP(), []int{17}
}

func (x *CreateInstructionMetadata) GetInstruction() string {
	if x != nil {
		return x.Instruction
	}
	return ""
}

func (x *CreateInstructionMetadata) GetPartialFailures() []*status.Status {
	if x != nil {
		return x.PartialFailures
	}
	return nil
}

func (x *CreateInstructionMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

var File_google_cloud_datalabeling_v1beta1_operations_proto protoreflect.FileDescriptor

var file_google_cloud_datalabeling_v1beta1_operations_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69,
	0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x68, 0x75, 0x6d, 0x61,
	0x6e, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x7b, 0x0a, 0x1b, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x1f, 0x0a, 0x0b,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x21, 0x0a,
	0x0c, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0b, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x22, 0xa1, 0x02, 0x0a, 0x1b, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x65,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4e,
	0x0a, 0x0b, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x52, 0x0a, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x54,
	0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0xb3, 0x01, 0x0a, 0x1b, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x3d,
	0x0a, 0x10, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0f, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x12, 0x3b, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xb3, 0x01, 0x0a, 0x1b, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x12, 0x3d, 0x0a, 0x10, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f,
	0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0x83, 0x0f, 0x0a, 0x16, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x90, 0x01, 0x0a, 0x1c,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x48, 0x00, 0x52, 0x1a, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x88,
	0x01, 0x0a, 0x1a, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x5f, 0x62, 0x6f, 0x78, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00,
	0x52, 0x17, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42,
	0x6f, 0x78, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x8b, 0x01, 0x0a, 0x1b, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c,
	0x79, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x6f,
	0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x18, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0xa1, 0x01, 0x0a, 0x23, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x5f, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x5f, 0x62, 0x6f, 0x78, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x4f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x42, 0x6f, 0x75, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x1f, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x4f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x42, 0x6f, 0x78, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x7e, 0x0a, 0x16, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69,
	0x6e, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x14, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x79,
	0x6c, 0x69, 0x6e, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x8a, 0x01, 0x0a, 0x1a,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x18,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x90, 0x01, 0x0a, 0x1c, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52,
	0x1a, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x94, 0x01, 0x0a, 0x1e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x64, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x1b, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x12, 0x91, 0x01, 0x0a, 0x1d, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54,
	0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x1a, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x75, 0x0a, 0x13, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x11, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x8d, 0x01,
	0x0a, 0x1b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x54, 0x65, 0x78,
	0x74, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x48, 0x00, 0x52, 0x19, 0x74, 0x65, 0x78, 0x74, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x94, 0x01,
	0x0a, 0x1e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x65, 0x78,
	0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x54, 0x65, 0x78, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x1b, 0x74, 0x65, 0x78, 0x74, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f,
	0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12,
	0x3d, 0x0a, 0x10, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0f, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x12, 0x3b,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x88, 0x01, 0x0a, 0x29, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x5b, 0x0a, 0x0c, 0x62, 0x61, 0x73, 0x69, 0x63, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48,
	0x75, 0x6d, 0x61, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x62, 0x61, 0x73, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0x85, 0x01, 0x0a, 0x26, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5b, 0x0a, 0x0c,
	0x62, 0x61, 0x73, 0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x62, 0x61,
	0x73, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x8d, 0x01, 0x0a, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x64,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5b, 0x0a, 0x0c,
	0x62, 0x61, 0x73, 0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x62, 0x61,
	0x73, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x86, 0x01, 0x0a, 0x27, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x50, 0x6f, 0x6c, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5b, 0x0a, 0x0c, 0x62, 0x61, 0x73, 0x69, 0x63, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x62, 0x61, 0x73, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x82, 0x01, 0x0a, 0x23, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5b, 0x0a, 0x0c, 0x62, 0x61,
	0x73, 0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x62, 0x61, 0x73, 0x69,
	0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x86, 0x01, 0x0a, 0x27, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x5b, 0x0a, 0x0c, 0x62, 0x61, 0x73, 0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75,
	0x6d, 0x61, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0b, 0x62, 0x61, 0x73, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0x88, 0x01, 0x0a, 0x29, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5b,
	0x0a, 0x0c, 0x62, 0x61, 0x73, 0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b,
	0x62, 0x61, 0x73, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x89, 0x01, 0x0a, 0x2a,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5b, 0x0a, 0x0c, 0x62, 0x61,
	0x73, 0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x62, 0x61, 0x73, 0x69,
	0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x88, 0x01, 0x0a, 0x29, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x72, 0x61, 0x63,
	0x6b, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5b, 0x0a, 0x0c, 0x62, 0x61, 0x73, 0x69, 0x63, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x62, 0x61, 0x73, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x7f, 0x0a, 0x20, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5b, 0x0a, 0x0c, 0x62, 0x61, 0x73, 0x69, 0x63, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x62, 0x61, 0x73, 0x69, 0x63, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x22, 0x87, 0x01, 0x0a, 0x28, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x54, 0x65, 0x78,
	0x74, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x5b, 0x0a, 0x0c, 0x62, 0x61, 0x73, 0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x0b, 0x62, 0x61, 0x73, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x89, 0x01,
	0x0a, 0x2a, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x54, 0x65, 0x78, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5b, 0x0a, 0x0c,
	0x62, 0x61, 0x73, 0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x62, 0x61,
	0x73, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xb9, 0x01, 0x0a, 0x19, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x20, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x69, 0x6e,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x10, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c,
	0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x42, 0xe3, 0x01, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x50,
	0x01, 0x5a, 0x49, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x69, 0x6e, 0x67, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x70, 0x62, 0x3b, 0x64, 0x61,
	0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x70, 0x62, 0xaa, 0x02, 0x21, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31,
	0xca, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x5c, 0x56, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69,
	0x6e, 0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescOnce sync.Once
	file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescData = file_google_cloud_datalabeling_v1beta1_operations_proto_rawDesc
)

func file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescGZIP() []byte {
	file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescOnce.Do(func() {
		file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescData)
	})
	return file_google_cloud_datalabeling_v1beta1_operations_proto_rawDescData
}

var file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_google_cloud_datalabeling_v1beta1_operations_proto_goTypes = []any{
	(*ImportDataOperationResponse)(nil),                    // 0: google.cloud.datalabeling.v1beta1.ImportDataOperationResponse
	(*ExportDataOperationResponse)(nil),                    // 1: google.cloud.datalabeling.v1beta1.ExportDataOperationResponse
	(*ImportDataOperationMetadata)(nil),                    // 2: google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata
	(*ExportDataOperationMetadata)(nil),                    // 3: google.cloud.datalabeling.v1beta1.ExportDataOperationMetadata
	(*LabelOperationMetadata)(nil),                         // 4: google.cloud.datalabeling.v1beta1.LabelOperationMetadata
	(*LabelImageClassificationOperationMetadata)(nil),      // 5: google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata
	(*LabelImageBoundingBoxOperationMetadata)(nil),         // 6: google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata
	(*LabelImageOrientedBoundingBoxOperationMetadata)(nil), // 7: google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata
	(*LabelImageBoundingPolyOperationMetadata)(nil),        // 8: google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata
	(*LabelImagePolylineOperationMetadata)(nil),            // 9: google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata
	(*LabelImageSegmentationOperationMetadata)(nil),        // 10: google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata
	(*LabelVideoClassificationOperationMetadata)(nil),      // 11: google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata
	(*LabelVideoObjectDetectionOperationMetadata)(nil),     // 12: google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata
	(*LabelVideoObjectTrackingOperationMetadata)(nil),      // 13: google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata
	(*LabelVideoEventOperationMetadata)(nil),               // 14: google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata
	(*LabelTextClassificationOperationMetadata)(nil),       // 15: google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata
	(*LabelTextEntityExtractionOperationMetadata)(nil),     // 16: google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata
	(*CreateInstructionMetadata)(nil),                      // 17: google.cloud.datalabeling.v1beta1.CreateInstructionMetadata
	(*LabelStats)(nil),                                     // 18: google.cloud.datalabeling.v1beta1.LabelStats
	(*OutputConfig)(nil),                                   // 19: google.cloud.datalabeling.v1beta1.OutputConfig
	(*status.Status)(nil),                                  // 20: google.rpc.Status
	(*timestamppb.Timestamp)(nil),                          // 21: google.protobuf.Timestamp
	(*HumanAnnotationConfig)(nil),                          // 22: google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
}
var file_google_cloud_datalabeling_v1beta1_operations_proto_depIdxs = []int32{
	18, // 0: google.cloud.datalabeling.v1beta1.ExportDataOperationResponse.label_stats:type_name -> google.cloud.datalabeling.v1beta1.LabelStats
	19, // 1: google.cloud.datalabeling.v1beta1.ExportDataOperationResponse.output_config:type_name -> google.cloud.datalabeling.v1beta1.OutputConfig
	20, // 2: google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata.partial_failures:type_name -> google.rpc.Status
	21, // 3: google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	20, // 4: google.cloud.datalabeling.v1beta1.ExportDataOperationMetadata.partial_failures:type_name -> google.rpc.Status
	21, // 5: google.cloud.datalabeling.v1beta1.ExportDataOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	5,  // 6: google.cloud.datalabeling.v1beta1.LabelOperationMetadata.image_classification_details:type_name -> google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata
	6,  // 7: google.cloud.datalabeling.v1beta1.LabelOperationMetadata.image_bounding_box_details:type_name -> google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata
	8,  // 8: google.cloud.datalabeling.v1beta1.LabelOperationMetadata.image_bounding_poly_details:type_name -> google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata
	7,  // 9: google.cloud.datalabeling.v1beta1.LabelOperationMetadata.image_oriented_bounding_box_details:type_name -> google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata
	9,  // 10: google.cloud.datalabeling.v1beta1.LabelOperationMetadata.image_polyline_details:type_name -> google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata
	10, // 11: google.cloud.datalabeling.v1beta1.LabelOperationMetadata.image_segmentation_details:type_name -> google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata
	11, // 12: google.cloud.datalabeling.v1beta1.LabelOperationMetadata.video_classification_details:type_name -> google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata
	12, // 13: google.cloud.datalabeling.v1beta1.LabelOperationMetadata.video_object_detection_details:type_name -> google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata
	13, // 14: google.cloud.datalabeling.v1beta1.LabelOperationMetadata.video_object_tracking_details:type_name -> google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata
	14, // 15: google.cloud.datalabeling.v1beta1.LabelOperationMetadata.video_event_details:type_name -> google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata
	15, // 16: google.cloud.datalabeling.v1beta1.LabelOperationMetadata.text_classification_details:type_name -> google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata
	16, // 17: google.cloud.datalabeling.v1beta1.LabelOperationMetadata.text_entity_extraction_details:type_name -> google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata
	20, // 18: google.cloud.datalabeling.v1beta1.LabelOperationMetadata.partial_failures:type_name -> google.rpc.Status
	21, // 19: google.cloud.datalabeling.v1beta1.LabelOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	22, // 20: google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata.basic_config:type_name -> google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
	22, // 21: google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata.basic_config:type_name -> google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
	22, // 22: google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata.basic_config:type_name -> google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
	22, // 23: google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata.basic_config:type_name -> google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
	22, // 24: google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata.basic_config:type_name -> google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
	22, // 25: google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata.basic_config:type_name -> google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
	22, // 26: google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata.basic_config:type_name -> google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
	22, // 27: google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata.basic_config:type_name -> google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
	22, // 28: google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata.basic_config:type_name -> google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
	22, // 29: google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata.basic_config:type_name -> google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
	22, // 30: google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata.basic_config:type_name -> google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
	22, // 31: google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata.basic_config:type_name -> google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
	20, // 32: google.cloud.datalabeling.v1beta1.CreateInstructionMetadata.partial_failures:type_name -> google.rpc.Status
	21, // 33: google.cloud.datalabeling.v1beta1.CreateInstructionMetadata.create_time:type_name -> google.protobuf.Timestamp
	34, // [34:34] is the sub-list for method output_type
	34, // [34:34] is the sub-list for method input_type
	34, // [34:34] is the sub-list for extension type_name
	34, // [34:34] is the sub-list for extension extendee
	0,  // [0:34] is the sub-list for field type_name
}

func init() { file_google_cloud_datalabeling_v1beta1_operations_proto_init() }
func file_google_cloud_datalabeling_v1beta1_operations_proto_init() {
	if File_google_cloud_datalabeling_v1beta1_operations_proto != nil {
		return
	}
	file_google_cloud_datalabeling_v1beta1_dataset_proto_init()
	file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_init()
	file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes[4].OneofWrappers = []any{
		(*LabelOperationMetadata_ImageClassificationDetails)(nil),
		(*LabelOperationMetadata_ImageBoundingBoxDetails)(nil),
		(*LabelOperationMetadata_ImageBoundingPolyDetails)(nil),
		(*LabelOperationMetadata_ImageOrientedBoundingBoxDetails)(nil),
		(*LabelOperationMetadata_ImagePolylineDetails)(nil),
		(*LabelOperationMetadata_ImageSegmentationDetails)(nil),
		(*LabelOperationMetadata_VideoClassificationDetails)(nil),
		(*LabelOperationMetadata_VideoObjectDetectionDetails)(nil),
		(*LabelOperationMetadata_VideoObjectTrackingDetails)(nil),
		(*LabelOperationMetadata_VideoEventDetails)(nil),
		(*LabelOperationMetadata_TextClassificationDetails)(nil),
		(*LabelOperationMetadata_TextEntityExtractionDetails)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datalabeling_v1beta1_operations_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_datalabeling_v1beta1_operations_proto_goTypes,
		DependencyIndexes: file_google_cloud_datalabeling_v1beta1_operations_proto_depIdxs,
		MessageInfos:      file_google_cloud_datalabeling_v1beta1_operations_proto_msgTypes,
	}.Build()
	File_google_cloud_datalabeling_v1beta1_operations_proto = out.File
	file_google_cloud_datalabeling_v1beta1_operations_proto_rawDesc = nil
	file_google_cloud_datalabeling_v1beta1_operations_proto_goTypes = nil
	file_google_cloud_datalabeling_v1beta1_operations_proto_depIdxs = nil
}
