/*****************************************************************************
* Model: dpp.qm
* File:  ./dpp.h
*
* This code has been generated by QM tool (see state-machine.com/qm).
* DO NOT EDIT THIS FILE MANUALLY. All your changes will be lost.
*
* This program is open source software: you can redistribute it and/or
* modify it under the terms of the GNU General Public License as published
* by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
* or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
* for more details.
*****************************************************************************/
/*${.::dpp.h} ..............................................................*/
#ifndef dpp_h
#define dpp_h

enum DPPSignals {
    EAT_SIG = Q_USER_SIG, /* published by Table to let a philosopher eat */
    DONE_SIG,       /* published by Philosopher when done eating */
    PAUSE_SIG,      /* published by BSP to pause serving forks */
    SERVE_SIG,      /* published by BSP to serve re-start serving forks */
    TERMINATE_SIG,  /* published by BSP to terminate the application */
    MAX_PUB_SIG,    /* the last published signal */

    HUNGRY_SIG,     /* posted direclty to Table from hungry Philo */
    TIMEOUT_SIG,    /* used by Philosophers for time events */
    MAX_SIG         /* the last signal */
};


#if ((QP_VERSION < 580) || (QP_VERSION != ((QP_RELEASE^4294967295U) % 0x3E8)))
#error qpc version 5.8.0 or higher required
#endif

/*${Events::TableEvt} ......................................................*/
typedef struct {
/* protected: */
    QEvt super;

/* public: */
    uint8_t philoNum;
} TableEvt;


/* number of philosophers
*
* NOTE: Only one Philo, because of the ThreadX demo library limits
*/
#define N_PHILO ((uint8_t)1)

/*${AOs::Philo_ctor} .......................................................*/
void Philo_ctor(void);

/*${AOs::Table_ctor} .......................................................*/
void Table_ctor(void);


extern QMActive * const AO_Philo[N_PHILO];

extern QMActive * const AO_Table;


#endif /* dpp_h */
