/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.tree;

import com.ca.directory.jxplorer.tree.SmartNode;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class SmartTreeCellRenderer
extends DefaultTreeCellRenderer {
    boolean useIcons = true;
    public JLabel displayLabel = new JLabel("label");
    private static final Color BLUE = new Color(119);
    private static final Color WHITE = Color.white;
    private static final Color BLACK = Color.black;
    private Color currentBackground = null;
    private Color currentForeground = null;
    private ImageIcon currentIcon = null;

    public SmartTreeCellRenderer() {
    }

    public SmartTreeCellRenderer(boolean usingIcons) {
        this();
        this.useIcons = usingIcons;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object icon = null;
        if (value instanceof SmartNode) {
            SmartNode node = (SmartNode)value;
            if (selected) {
                this.currentForeground = WHITE;
                this.currentBackground = BLUE;
                this.displayLabel.setForeground(this.currentForeground);
                this.displayLabel.setBackground(this.currentBackground);
                this.displayLabel.setOpaque(true);
            } else if (this.currentBackground != WHITE) {
                this.currentForeground = BLACK;
                this.currentBackground = WHITE;
                this.displayLabel.setForeground(this.currentForeground);
                this.displayLabel.setBackground(this.currentBackground);
                this.displayLabel.setOpaque(false);
            }
            if (node.isMultiValued()) {
                StringBuffer buffy = new StringBuffer();
                buffy.append(node.rdn.getRawVal(0));
                int size = node.rdn.size();
                for (int i = 1; i < size; ++i) {
                    buffy.append(" + ");
                    buffy.append(node.rdn.getRawVal(i));
                }
                this.displayLabel.setText(buffy.toString());
            } else if (node.isDummy()) {
                this.displayLabel.setText(node.getDummyMessage());
            } else if (node.isBlankRoot()) {
                this.displayLabel.setText(node.getBlankRootName());
            } else {
                this.displayLabel.setText(node.rdn.getRawVal(0));
            }
            try {
                if (node.getIcon() != this.currentIcon) {
                    this.currentIcon = node.getIcon();
                    this.displayLabel.setIcon(this.currentIcon);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return this.displayLabel;
        }
        this.displayLabel.setText(value.toString());
        return this.displayLabel;
    }
}

