package aiworkspace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMembers invokes the aiworkspace.DeleteMembers API synchronously
func (client *Client) DeleteMembers(request *DeleteMembersRequest) (response *DeleteMembersResponse, err error) {
	response = CreateDeleteMembersResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMembersWithChan invokes the aiworkspace.DeleteMembers API asynchronously
func (client *Client) DeleteMembersWithChan(request *DeleteMembersRequest) (<-chan *DeleteMembersResponse, <-chan error) {
	responseChan := make(chan *DeleteMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMembersWithCallback invokes the aiworkspace.DeleteMembers API asynchronously
func (client *Client) DeleteMembersWithCallback(request *DeleteMembersRequest, callback func(response *DeleteMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMembersResponse
		var err error
		defer close(result)
		response, err = client.DeleteMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMembersRequest is the request struct for api DeleteMembers
type DeleteMembersRequest struct {
	*requests.RoaRequest
	MemberIds   string `position:"Query" name:"MemberIds"`
	WorkspaceId string `position:"Path" name:"WorkspaceId"`
}

// DeleteMembersResponse is the response struct for api DeleteMembers
type DeleteMembersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteMembersRequest creates a request to invoke DeleteMembers API
func CreateDeleteMembersRequest() (request *DeleteMembersRequest) {
	request = &DeleteMembersRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("AIWorkSpace", "2021-02-04", "DeleteMembers", "/api/v1/workspaces/[WorkspaceId]/members", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteMembersResponse creates a response to parse from DeleteMembers response
func CreateDeleteMembersResponse() (response *DeleteMembersResponse) {
	response = &DeleteMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
