package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// LoadBalancerJoinSecurityGroup invokes the alb.LoadBalancerJoinSecurityGroup API synchronously
func (client *Client) LoadBalancerJoinSecurityGroup(request *LoadBalancerJoinSecurityGroupRequest) (response *LoadBalancerJoinSecurityGroupResponse, err error) {
	response = CreateLoadBalancerJoinSecurityGroupResponse()
	err = client.DoAction(request, response)
	return
}

// LoadBalancerJoinSecurityGroupWithChan invokes the alb.LoadBalancerJoinSecurityGroup API asynchronously
func (client *Client) LoadBalancerJoinSecurityGroupWithChan(request *LoadBalancerJoinSecurityGroupRequest) (<-chan *LoadBalancerJoinSecurityGroupResponse, <-chan error) {
	responseChan := make(chan *LoadBalancerJoinSecurityGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.LoadBalancerJoinSecurityGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// LoadBalancerJoinSecurityGroupWithCallback invokes the alb.LoadBalancerJoinSecurityGroup API asynchronously
func (client *Client) LoadBalancerJoinSecurityGroupWithCallback(request *LoadBalancerJoinSecurityGroupRequest, callback func(response *LoadBalancerJoinSecurityGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *LoadBalancerJoinSecurityGroupResponse
		var err error
		defer close(result)
		response, err = client.LoadBalancerJoinSecurityGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// LoadBalancerJoinSecurityGroupRequest is the request struct for api LoadBalancerJoinSecurityGroup
type LoadBalancerJoinSecurityGroupRequest struct {
	*requests.RpcRequest
	ClientToken      string           `position:"Query" name:"ClientToken"`
	DryRun           requests.Boolean `position:"Query" name:"DryRun"`
	SecurityGroupIds *[]string        `position:"Query" name:"SecurityGroupIds"  type:"Repeated"`
	LoadBalancerId   string           `position:"Query" name:"LoadBalancerId"`
}

// LoadBalancerJoinSecurityGroupResponse is the response struct for api LoadBalancerJoinSecurityGroup
type LoadBalancerJoinSecurityGroupResponse struct {
	*responses.BaseResponse
	JobId     string `json:"JobId" xml:"JobId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateLoadBalancerJoinSecurityGroupRequest creates a request to invoke LoadBalancerJoinSecurityGroup API
func CreateLoadBalancerJoinSecurityGroupRequest() (request *LoadBalancerJoinSecurityGroupRequest) {
	request = &LoadBalancerJoinSecurityGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "LoadBalancerJoinSecurityGroup", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateLoadBalancerJoinSecurityGroupResponse creates a response to parse from LoadBalancerJoinSecurityGroup response
func CreateLoadBalancerJoinSecurityGroupResponse() (response *LoadBalancerJoinSecurityGroupResponse) {
	response = &LoadBalancerJoinSecurityGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
