package alimt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTranslateImageBatchResult invokes the alimt.GetTranslateImageBatchResult API synchronously
func (client *Client) GetTranslateImageBatchResult(request *GetTranslateImageBatchResultRequest) (response *GetTranslateImageBatchResultResponse, err error) {
	response = CreateGetTranslateImageBatchResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetTranslateImageBatchResultWithChan invokes the alimt.GetTranslateImageBatchResult API asynchronously
func (client *Client) GetTranslateImageBatchResultWithChan(request *GetTranslateImageBatchResultRequest) (<-chan *GetTranslateImageBatchResultResponse, <-chan error) {
	responseChan := make(chan *GetTranslateImageBatchResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTranslateImageBatchResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTranslateImageBatchResultWithCallback invokes the alimt.GetTranslateImageBatchResult API asynchronously
func (client *Client) GetTranslateImageBatchResultWithCallback(request *GetTranslateImageBatchResultRequest, callback func(response *GetTranslateImageBatchResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTranslateImageBatchResultResponse
		var err error
		defer close(result)
		response, err = client.GetTranslateImageBatchResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTranslateImageBatchResultRequest is the request struct for api GetTranslateImageBatchResult
type GetTranslateImageBatchResultRequest struct {
	*requests.RpcRequest
	TaskId string `position:"Body" name:"TaskId"`
}

// GetTranslateImageBatchResultResponse is the response struct for api GetTranslateImageBatchResult
type GetTranslateImageBatchResultResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetTranslateImageBatchResultRequest creates a request to invoke GetTranslateImageBatchResult API
func CreateGetTranslateImageBatchResultRequest() (request *GetTranslateImageBatchResultRequest) {
	request = &GetTranslateImageBatchResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alimt", "2018-10-12", "GetTranslateImageBatchResult", "", "")
	request.Method = requests.POST
	return
}

// CreateGetTranslateImageBatchResultResponse creates a response to parse from GetTranslateImageBatchResult response
func CreateGetTranslateImageBatchResultResponse() (response *GetTranslateImageBatchResultResponse) {
	response = &GetTranslateImageBatchResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
