package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePrometheusMonitoring invokes the arms.CreatePrometheusMonitoring API synchronously
func (client *Client) CreatePrometheusMonitoring(request *CreatePrometheusMonitoringRequest) (response *CreatePrometheusMonitoringResponse, err error) {
	response = CreateCreatePrometheusMonitoringResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePrometheusMonitoringWithChan invokes the arms.CreatePrometheusMonitoring API asynchronously
func (client *Client) CreatePrometheusMonitoringWithChan(request *CreatePrometheusMonitoringRequest) (<-chan *CreatePrometheusMonitoringResponse, <-chan error) {
	responseChan := make(chan *CreatePrometheusMonitoringResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePrometheusMonitoring(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePrometheusMonitoringWithCallback invokes the arms.CreatePrometheusMonitoring API asynchronously
func (client *Client) CreatePrometheusMonitoringWithCallback(request *CreatePrometheusMonitoringRequest, callback func(response *CreatePrometheusMonitoringResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePrometheusMonitoringResponse
		var err error
		defer close(result)
		response, err = client.CreatePrometheusMonitoring(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePrometheusMonitoringRequest is the request struct for api CreatePrometheusMonitoring
type CreatePrometheusMonitoringRequest struct {
	*requests.RpcRequest
	ConfigYaml string `position:"Body" name:"ConfigYaml"`
	ClusterId  string `position:"Query" name:"ClusterId"`
	Type       string `position:"Query" name:"Type"`
	Status     string `position:"Query" name:"Status"`
}

// CreatePrometheusMonitoringResponse is the response struct for api CreatePrometheusMonitoring
type CreatePrometheusMonitoringResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateCreatePrometheusMonitoringRequest creates a request to invoke CreatePrometheusMonitoring API
func CreateCreatePrometheusMonitoringRequest() (request *CreatePrometheusMonitoringRequest) {
	request = &CreatePrometheusMonitoringRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "CreatePrometheusMonitoring", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreatePrometheusMonitoringResponse creates a response to parse from CreatePrometheusMonitoring response
func CreateCreatePrometheusMonitoringResponse() (response *CreatePrometheusMonitoringResponse) {
	response = &CreatePrometheusMonitoringResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
