package bpstudio

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ValidateApplication invokes the bpstudio.ValidateApplication API synchronously
func (client *Client) ValidateApplication(request *ValidateApplicationRequest) (response *ValidateApplicationResponse, err error) {
	response = CreateValidateApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// ValidateApplicationWithChan invokes the bpstudio.ValidateApplication API asynchronously
func (client *Client) ValidateApplicationWithChan(request *ValidateApplicationRequest) (<-chan *ValidateApplicationResponse, <-chan error) {
	responseChan := make(chan *ValidateApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ValidateApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ValidateApplicationWithCallback invokes the bpstudio.ValidateApplication API asynchronously
func (client *Client) ValidateApplicationWithCallback(request *ValidateApplicationRequest, callback func(response *ValidateApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ValidateApplicationResponse
		var err error
		defer close(result)
		response, err = client.ValidateApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ValidateApplicationRequest is the request struct for api ValidateApplication
type ValidateApplicationRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Body" name:"ResourceGroupId"`
	ApplicationId   string `position:"Query" name:"ApplicationId"`
}

// ValidateApplicationResponse is the response struct for api ValidateApplication
type ValidateApplicationResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      int    `json:"Code" xml:"Code"`
}

// CreateValidateApplicationRequest creates a request to invoke ValidateApplication API
func CreateValidateApplicationRequest() (request *ValidateApplicationRequest) {
	request = &ValidateApplicationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BPStudio", "2021-09-31", "ValidateApplication", "bpstudio", "openAPI")
	request.Method = requests.POST
	return
}

// CreateValidateApplicationResponse creates a response to parse from ValidateApplication response
func CreateValidateApplicationResponse() (response *ValidateApplicationResponse) {
	response = &ValidateApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
