package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FailCards invokes the cc5g.FailCards API synchronously
func (client *Client) FailCards(request *FailCardsRequest) (response *FailCardsResponse, err error) {
	response = CreateFailCardsResponse()
	err = client.DoAction(request, response)
	return
}

// FailCardsWithChan invokes the cc5g.FailCards API asynchronously
func (client *Client) FailCardsWithChan(request *FailCardsRequest) (<-chan *FailCardsResponse, <-chan error) {
	responseChan := make(chan *FailCardsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FailCards(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FailCardsWithCallback invokes the cc5g.FailCards API asynchronously
func (client *Client) FailCardsWithCallback(request *FailCardsRequest, callback func(response *FailCardsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FailCardsResponse
		var err error
		defer close(result)
		response, err = client.FailCards(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FailCardsRequest is the request struct for api FailCards
type FailCardsRequest struct {
	*requests.RpcRequest
	Iccids      *[]string        `position:"Query" name:"Iccids"  type:"Repeated"`
	DryRun      requests.Boolean `position:"Query" name:"DryRun"`
	ClientToken string           `position:"Query" name:"ClientToken"`
}

// FailCardsResponse is the response struct for api FailCards
type FailCardsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateFailCardsRequest creates a request to invoke FailCards API
func CreateFailCardsRequest() (request *FailCardsRequest) {
	request = &FailCardsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "FailCards", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateFailCardsResponse creates a response to parse from FailCards response
func CreateFailCardsResponse() (response *FailCardsResponse) {
	response = &FailCardsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
