package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateGroupDnsAuthorizationRule invokes the cc5g.UpdateGroupDnsAuthorizationRule API synchronously
func (client *Client) UpdateGroupDnsAuthorizationRule(request *UpdateGroupDnsAuthorizationRuleRequest) (response *UpdateGroupDnsAuthorizationRuleResponse, err error) {
	response = CreateUpdateGroupDnsAuthorizationRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateGroupDnsAuthorizationRuleWithChan invokes the cc5g.UpdateGroupDnsAuthorizationRule API asynchronously
func (client *Client) UpdateGroupDnsAuthorizationRuleWithChan(request *UpdateGroupDnsAuthorizationRuleRequest) (<-chan *UpdateGroupDnsAuthorizationRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateGroupDnsAuthorizationRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateGroupDnsAuthorizationRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateGroupDnsAuthorizationRuleWithCallback invokes the cc5g.UpdateGroupDnsAuthorizationRule API asynchronously
func (client *Client) UpdateGroupDnsAuthorizationRuleWithCallback(request *UpdateGroupDnsAuthorizationRuleRequest, callback func(response *UpdateGroupDnsAuthorizationRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateGroupDnsAuthorizationRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateGroupDnsAuthorizationRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateGroupDnsAuthorizationRuleRequest is the request struct for api UpdateGroupDnsAuthorizationRule
type UpdateGroupDnsAuthorizationRuleRequest struct {
	*requests.RpcRequest
	WirelessCloudConnectorGroupId string           `position:"Query" name:"WirelessCloudConnectorGroupId"`
	ClientToken                   string           `position:"Query" name:"ClientToken"`
	Description                   string           `position:"Query" name:"Description"`
	DryRun                        requests.Boolean `position:"Query" name:"DryRun"`
	SourceDNSIp                   string           `position:"Query" name:"SourceDNSIp"`
	AuthorizationRuleId           string           `position:"Query" name:"AuthorizationRuleId"`
	DestinationIp                 string           `position:"Query" name:"DestinationIp"`
	Name                          string           `position:"Query" name:"Name"`
}

// UpdateGroupDnsAuthorizationRuleResponse is the response struct for api UpdateGroupDnsAuthorizationRule
type UpdateGroupDnsAuthorizationRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateGroupDnsAuthorizationRuleRequest creates a request to invoke UpdateGroupDnsAuthorizationRule API
func CreateUpdateGroupDnsAuthorizationRuleRequest() (request *UpdateGroupDnsAuthorizationRuleRequest) {
	request = &UpdateGroupDnsAuthorizationRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "UpdateGroupDnsAuthorizationRule", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateGroupDnsAuthorizationRuleResponse creates a response to parse from UpdateGroupDnsAuthorizationRule response
func CreateUpdateGroupDnsAuthorizationRuleResponse() (response *UpdateGroupDnsAuthorizationRuleResponse) {
	response = &UpdateGroupDnsAuthorizationRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
