package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetVoicemailRecording invokes the ccc.GetVoicemailRecording API synchronously
func (client *Client) GetVoicemailRecording(request *GetVoicemailRecordingRequest) (response *GetVoicemailRecordingResponse, err error) {
	response = CreateGetVoicemailRecordingResponse()
	err = client.DoAction(request, response)
	return
}

// GetVoicemailRecordingWithChan invokes the ccc.GetVoicemailRecording API asynchronously
func (client *Client) GetVoicemailRecordingWithChan(request *GetVoicemailRecordingRequest) (<-chan *GetVoicemailRecordingResponse, <-chan error) {
	responseChan := make(chan *GetVoicemailRecordingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetVoicemailRecording(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetVoicemailRecordingWithCallback invokes the ccc.GetVoicemailRecording API asynchronously
func (client *Client) GetVoicemailRecordingWithCallback(request *GetVoicemailRecordingRequest, callback func(response *GetVoicemailRecordingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetVoicemailRecordingResponse
		var err error
		defer close(result)
		response, err = client.GetVoicemailRecording(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetVoicemailRecordingRequest is the request struct for api GetVoicemailRecording
type GetVoicemailRecordingRequest struct {
	*requests.RpcRequest
	ContactId  string `position:"Query" name:"ContactId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetVoicemailRecordingResponse is the response struct for api GetVoicemailRecording
type GetVoicemailRecordingResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetVoicemailRecordingRequest creates a request to invoke GetVoicemailRecording API
func CreateGetVoicemailRecordingRequest() (request *GetVoicemailRecordingRequest) {
	request = &GetVoicemailRecordingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "GetVoicemailRecording", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetVoicemailRecordingResponse creates a response to parse from GetVoicemailRecording response
func CreateGetVoicemailRecordingResponse() (response *GetVoicemailRecordingResponse) {
	response = &GetVoicemailRecordingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
