package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLegacyAgentStatusLogs invokes the ccc.ListLegacyAgentStatusLogs API synchronously
func (client *Client) ListLegacyAgentStatusLogs(request *ListLegacyAgentStatusLogsRequest) (response *ListLegacyAgentStatusLogsResponse, err error) {
	response = CreateListLegacyAgentStatusLogsResponse()
	err = client.DoAction(request, response)
	return
}

// ListLegacyAgentStatusLogsWithChan invokes the ccc.ListLegacyAgentStatusLogs API asynchronously
func (client *Client) ListLegacyAgentStatusLogsWithChan(request *ListLegacyAgentStatusLogsRequest) (<-chan *ListLegacyAgentStatusLogsResponse, <-chan error) {
	responseChan := make(chan *ListLegacyAgentStatusLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLegacyAgentStatusLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLegacyAgentStatusLogsWithCallback invokes the ccc.ListLegacyAgentStatusLogs API asynchronously
func (client *Client) ListLegacyAgentStatusLogsWithCallback(request *ListLegacyAgentStatusLogsRequest, callback func(response *ListLegacyAgentStatusLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLegacyAgentStatusLogsResponse
		var err error
		defer close(result)
		response, err = client.ListLegacyAgentStatusLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLegacyAgentStatusLogsRequest is the request struct for api ListLegacyAgentStatusLogs
type ListLegacyAgentStatusLogsRequest struct {
	*requests.RpcRequest
	AgentId    string           `position:"Query" name:"AgentId"`
	EndTime    requests.Integer `position:"Query" name:"EndTime"`
	StartTime  requests.Integer `position:"Query" name:"StartTime"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// ListLegacyAgentStatusLogsResponse is the response struct for api ListLegacyAgentStatusLogs
type ListLegacyAgentStatusLogsResponse struct {
	*responses.BaseResponse
	HttpStatusCode int                             `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string                          `json:"Code" xml:"Code"`
	Message        string                          `json:"Message" xml:"Message"`
	RequestId      string                          `json:"RequestId" xml:"RequestId"`
	Success        bool                            `json:"Success" xml:"Success"`
	Data           DataInListLegacyAgentStatusLogs `json:"Data" xml:"Data"`
}

// CreateListLegacyAgentStatusLogsRequest creates a request to invoke ListLegacyAgentStatusLogs API
func CreateListLegacyAgentStatusLogsRequest() (request *ListLegacyAgentStatusLogsRequest) {
	request = &ListLegacyAgentStatusLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ListLegacyAgentStatusLogs", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListLegacyAgentStatusLogsResponse creates a response to parse from ListLegacyAgentStatusLogs response
func CreateListLegacyAgentStatusLogsResponse() (response *ListLegacyAgentStatusLogsResponse) {
	response = &ListLegacyAgentStatusLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
