package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRecentCallDetailRecords invokes the ccc.ListRecentCallDetailRecords API synchronously
func (client *Client) ListRecentCallDetailRecords(request *ListRecentCallDetailRecordsRequest) (response *ListRecentCallDetailRecordsResponse, err error) {
	response = CreateListRecentCallDetailRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// ListRecentCallDetailRecordsWithChan invokes the ccc.ListRecentCallDetailRecords API asynchronously
func (client *Client) ListRecentCallDetailRecordsWithChan(request *ListRecentCallDetailRecordsRequest) (<-chan *ListRecentCallDetailRecordsResponse, <-chan error) {
	responseChan := make(chan *ListRecentCallDetailRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRecentCallDetailRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRecentCallDetailRecordsWithCallback invokes the ccc.ListRecentCallDetailRecords API asynchronously
func (client *Client) ListRecentCallDetailRecordsWithCallback(request *ListRecentCallDetailRecordsRequest, callback func(response *ListRecentCallDetailRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRecentCallDetailRecordsResponse
		var err error
		defer close(result)
		response, err = client.ListRecentCallDetailRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRecentCallDetailRecordsRequest is the request struct for api ListRecentCallDetailRecords
type ListRecentCallDetailRecordsRequest struct {
	*requests.RpcRequest
	Criteria   string           `position:"Query" name:"Criteria"`
	EndTime    requests.Integer `position:"Query" name:"EndTime"`
	StartTime  requests.Integer `position:"Body" name:"StartTime"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// ListRecentCallDetailRecordsResponse is the response struct for api ListRecentCallDetailRecords
type ListRecentCallDetailRecordsResponse struct {
	*responses.BaseResponse
	Code           string                            `json:"Code" xml:"Code"`
	HttpStatusCode int                               `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                            `json:"Message" xml:"Message"`
	RequestId      string                            `json:"RequestId" xml:"RequestId"`
	Data           DataInListRecentCallDetailRecords `json:"Data" xml:"Data"`
}

// CreateListRecentCallDetailRecordsRequest creates a request to invoke ListRecentCallDetailRecords API
func CreateListRecentCallDetailRecordsRequest() (request *ListRecentCallDetailRecordsRequest) {
	request = &ListRecentCallDetailRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ListRecentCallDetailRecords", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListRecentCallDetailRecordsResponse creates a response to parse from ListRecentCallDetailRecords response
func CreateListRecentCallDetailRecordsResponse() (response *ListRecentCallDetailRecordsResponse) {
	response = &ListRecentCallDetailRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
