package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendDtmfSignaling invokes the ccc.SendDtmfSignaling API synchronously
func (client *Client) SendDtmfSignaling(request *SendDtmfSignalingRequest) (response *SendDtmfSignalingResponse, err error) {
	response = CreateSendDtmfSignalingResponse()
	err = client.DoAction(request, response)
	return
}

// SendDtmfSignalingWithChan invokes the ccc.SendDtmfSignaling API asynchronously
func (client *Client) SendDtmfSignalingWithChan(request *SendDtmfSignalingRequest) (<-chan *SendDtmfSignalingResponse, <-chan error) {
	responseChan := make(chan *SendDtmfSignalingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendDtmfSignaling(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendDtmfSignalingWithCallback invokes the ccc.SendDtmfSignaling API asynchronously
func (client *Client) SendDtmfSignalingWithCallback(request *SendDtmfSignalingRequest, callback func(response *SendDtmfSignalingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendDtmfSignalingResponse
		var err error
		defer close(result)
		response, err = client.SendDtmfSignaling(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendDtmfSignalingRequest is the request struct for api SendDtmfSignaling
type SendDtmfSignalingRequest struct {
	*requests.RpcRequest
	Dtmf       string `position:"Query" name:"Dtmf"`
	UserId     string `position:"Query" name:"UserId"`
	DeviceId   string `position:"Query" name:"DeviceId"`
	JobId      string `position:"Query" name:"JobId"`
	InstanceId string `position:"Query" name:"InstanceId"`
	ChannelId  string `position:"Query" name:"ChannelId"`
}

// SendDtmfSignalingResponse is the response struct for api SendDtmfSignaling
type SendDtmfSignalingResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Params         []string `json:"Params" xml:"Params"`
	Data           Data     `json:"Data" xml:"Data"`
}

// CreateSendDtmfSignalingRequest creates a request to invoke SendDtmfSignaling API
func CreateSendDtmfSignalingRequest() (request *SendDtmfSignalingRequest) {
	request = &SendDtmfSignalingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "SendDtmfSignaling", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSendDtmfSignalingResponse creates a response to parse from SendDtmfSignaling response
func CreateSendDtmfSignalingResponse() (response *SendDtmfSignalingResponse) {
	response = &SendDtmfSignalingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
