package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateConfigItems invokes the ccc.UpdateConfigItems API synchronously
func (client *Client) UpdateConfigItems(request *UpdateConfigItemsRequest) (response *UpdateConfigItemsResponse, err error) {
	response = CreateUpdateConfigItemsResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateConfigItemsWithChan invokes the ccc.UpdateConfigItems API asynchronously
func (client *Client) UpdateConfigItemsWithChan(request *UpdateConfigItemsRequest) (<-chan *UpdateConfigItemsResponse, <-chan error) {
	responseChan := make(chan *UpdateConfigItemsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateConfigItems(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateConfigItemsWithCallback invokes the ccc.UpdateConfigItems API asynchronously
func (client *Client) UpdateConfigItemsWithCallback(request *UpdateConfigItemsRequest, callback func(response *UpdateConfigItemsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateConfigItemsResponse
		var err error
		defer close(result)
		response, err = client.UpdateConfigItems(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateConfigItemsRequest is the request struct for api UpdateConfigItems
type UpdateConfigItemsRequest struct {
	*requests.RpcRequest
	ConfigItems string `position:"Query" name:"ConfigItems"`
	InstanceId  string `position:"Query" name:"InstanceId"`
	ObjectType  string `position:"Query" name:"ObjectType"`
	ObjectId    string `position:"Query" name:"ObjectId"`
}

// UpdateConfigItemsResponse is the response struct for api UpdateConfigItems
type UpdateConfigItemsResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateConfigItemsRequest creates a request to invoke UpdateConfigItems API
func CreateUpdateConfigItemsRequest() (request *UpdateConfigItemsRequest) {
	request = &UpdateConfigItemsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "UpdateConfigItems", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateConfigItemsResponse creates a response to parse from UpdateConfigItems response
func CreateUpdateConfigItemsResponse() (response *UpdateConfigItemsResponse) {
	response = &UpdateConfigItemsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
