package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAuth invokes the cloud_siem.DescribeAuth API synchronously
func (client *Client) DescribeAuth(request *DescribeAuthRequest) (response *DescribeAuthResponse, err error) {
	response = CreateDescribeAuthResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAuthWithChan invokes the cloud_siem.DescribeAuth API asynchronously
func (client *Client) DescribeAuthWithChan(request *DescribeAuthRequest) (<-chan *DescribeAuthResponse, <-chan error) {
	responseChan := make(chan *DescribeAuthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAuth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAuthWithCallback invokes the cloud_siem.DescribeAuth API asynchronously
func (client *Client) DescribeAuthWithCallback(request *DescribeAuthRequest, callback func(response *DescribeAuthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAuthResponse
		var err error
		defer close(result)
		response, err = client.DescribeAuth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAuthRequest is the request struct for api DescribeAuth
type DescribeAuthRequest struct {
	*requests.RpcRequest
}

// DescribeAuthResponse is the response struct for api DescribeAuth
type DescribeAuthResponse struct {
	*responses.BaseResponse
	Data      bool   `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeAuthRequest creates a request to invoke DescribeAuth API
func CreateDescribeAuthRequest() (request *DescribeAuthRequest) {
	request = &DescribeAuthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeAuth", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAuthResponse creates a response to parse from DescribeAuth response
func CreateDescribeAuthResponse() (response *DescribeAuthResponse) {
	response = &DescribeAuthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
