package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCustomizeRuleTestHistogram invokes the cloud_siem.DescribeCustomizeRuleTestHistogram API synchronously
func (client *Client) DescribeCustomizeRuleTestHistogram(request *DescribeCustomizeRuleTestHistogramRequest) (response *DescribeCustomizeRuleTestHistogramResponse, err error) {
	response = CreateDescribeCustomizeRuleTestHistogramResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCustomizeRuleTestHistogramWithChan invokes the cloud_siem.DescribeCustomizeRuleTestHistogram API asynchronously
func (client *Client) DescribeCustomizeRuleTestHistogramWithChan(request *DescribeCustomizeRuleTestHistogramRequest) (<-chan *DescribeCustomizeRuleTestHistogramResponse, <-chan error) {
	responseChan := make(chan *DescribeCustomizeRuleTestHistogramResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCustomizeRuleTestHistogram(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCustomizeRuleTestHistogramWithCallback invokes the cloud_siem.DescribeCustomizeRuleTestHistogram API asynchronously
func (client *Client) DescribeCustomizeRuleTestHistogramWithCallback(request *DescribeCustomizeRuleTestHistogramRequest, callback func(response *DescribeCustomizeRuleTestHistogramResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCustomizeRuleTestHistogramResponse
		var err error
		defer close(result)
		response, err = client.DescribeCustomizeRuleTestHistogram(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCustomizeRuleTestHistogramRequest is the request struct for api DescribeCustomizeRuleTestHistogram
type DescribeCustomizeRuleTestHistogramRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Body" name:"Id"`
}

// DescribeCustomizeRuleTestHistogramResponse is the response struct for api DescribeCustomizeRuleTestHistogram
type DescribeCustomizeRuleTestHistogramResponse struct {
	*responses.BaseResponse
	Success   bool       `json:"Success" xml:"Success"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeCustomizeRuleTestHistogramRequest creates a request to invoke DescribeCustomizeRuleTestHistogram API
func CreateDescribeCustomizeRuleTestHistogramRequest() (request *DescribeCustomizeRuleTestHistogramRequest) {
	request = &DescribeCustomizeRuleTestHistogramRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeCustomizeRuleTestHistogram", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCustomizeRuleTestHistogramResponse creates a response to parse from DescribeCustomizeRuleTestHistogram response
func CreateDescribeCustomizeRuleTestHistogramResponse() (response *DescribeCustomizeRuleTestHistogramResponse) {
	response = &DescribeCustomizeRuleTestHistogramResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
