package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetQuickQuery invokes the cloud_siem.GetQuickQuery API synchronously
func (client *Client) GetQuickQuery(request *GetQuickQueryRequest) (response *GetQuickQueryResponse, err error) {
	response = CreateGetQuickQueryResponse()
	err = client.DoAction(request, response)
	return
}

// GetQuickQueryWithChan invokes the cloud_siem.GetQuickQuery API asynchronously
func (client *Client) GetQuickQueryWithChan(request *GetQuickQueryRequest) (<-chan *GetQuickQueryResponse, <-chan error) {
	responseChan := make(chan *GetQuickQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetQuickQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetQuickQueryWithCallback invokes the cloud_siem.GetQuickQuery API asynchronously
func (client *Client) GetQuickQueryWithCallback(request *GetQuickQueryRequest, callback func(response *GetQuickQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetQuickQueryResponse
		var err error
		defer close(result)
		response, err = client.GetQuickQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetQuickQueryRequest is the request struct for api GetQuickQuery
type GetQuickQueryRequest struct {
	*requests.RpcRequest
	SearchName string `position:"Body" name:"SearchName"`
}

// GetQuickQueryResponse is the response struct for api GetQuickQuery
type GetQuickQueryResponse struct {
	*responses.BaseResponse
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateGetQuickQueryRequest creates a request to invoke GetQuickQuery API
func CreateGetQuickQueryRequest() (request *GetQuickQueryRequest) {
	request = &GetQuickQueryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "GetQuickQuery", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetQuickQueryResponse creates a response to parse from GetQuickQuery response
func CreateGetQuickQueryResponse() (response *GetQuickQueryResponse) {
	response = &GetQuickQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
