package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeImportOASTask invokes the cloudapi.DescribeImportOASTask API synchronously
func (client *Client) DescribeImportOASTask(request *DescribeImportOASTaskRequest) (response *DescribeImportOASTaskResponse, err error) {
	response = CreateDescribeImportOASTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeImportOASTaskWithChan invokes the cloudapi.DescribeImportOASTask API asynchronously
func (client *Client) DescribeImportOASTaskWithChan(request *DescribeImportOASTaskRequest) (<-chan *DescribeImportOASTaskResponse, <-chan error) {
	responseChan := make(chan *DescribeImportOASTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeImportOASTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeImportOASTaskWithCallback invokes the cloudapi.DescribeImportOASTask API asynchronously
func (client *Client) DescribeImportOASTaskWithCallback(request *DescribeImportOASTaskRequest, callback func(response *DescribeImportOASTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeImportOASTaskResponse
		var err error
		defer close(result)
		response, err = client.DescribeImportOASTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeImportOASTaskRequest is the request struct for api DescribeImportOASTask
type DescribeImportOASTaskRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	OperationId   string `position:"Query" name:"OperationId"`
}

// DescribeImportOASTaskResponse is the response struct for api DescribeImportOASTask
type DescribeImportOASTaskResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	TaskStatus   string       `json:"TaskStatus" xml:"TaskStatus"`
	ApiResults   ApiResults   `json:"ApiResults" xml:"ApiResults"`
	ModelResults ModelResults `json:"ModelResults" xml:"ModelResults"`
}

// CreateDescribeImportOASTaskRequest creates a request to invoke DescribeImportOASTask API
func CreateDescribeImportOASTaskRequest() (request *DescribeImportOASTaskRequest) {
	request = &DescribeImportOASTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeImportOASTask", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeImportOASTaskResponse creates a response to parse from DescribeImportOASTask response
func CreateDescribeImportOASTaskResponse() (response *DescribeImportOASTaskResponse) {
	response = &DescribeImportOASTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
