package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePageFaceVerifyData invokes the cloudauth.DescribePageFaceVerifyData API synchronously
func (client *Client) DescribePageFaceVerifyData(request *DescribePageFaceVerifyDataRequest) (response *DescribePageFaceVerifyDataResponse, err error) {
	response = CreateDescribePageFaceVerifyDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePageFaceVerifyDataWithChan invokes the cloudauth.DescribePageFaceVerifyData API asynchronously
func (client *Client) DescribePageFaceVerifyDataWithChan(request *DescribePageFaceVerifyDataRequest) (<-chan *DescribePageFaceVerifyDataResponse, <-chan error) {
	responseChan := make(chan *DescribePageFaceVerifyDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePageFaceVerifyData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePageFaceVerifyDataWithCallback invokes the cloudauth.DescribePageFaceVerifyData API asynchronously
func (client *Client) DescribePageFaceVerifyDataWithCallback(request *DescribePageFaceVerifyDataRequest, callback func(response *DescribePageFaceVerifyDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePageFaceVerifyDataResponse
		var err error
		defer close(result)
		response, err = client.DescribePageFaceVerifyData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePageFaceVerifyDataRequest is the request struct for api DescribePageFaceVerifyData
type DescribePageFaceVerifyDataRequest struct {
	*requests.RpcRequest
	ProductCode string           `position:"Query" name:"ProductCode"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	StartDate   string           `position:"Query" name:"StartDate"`
	EndDate     string           `position:"Query" name:"EndDate"`
	SceneId     requests.Integer `position:"Query" name:"SceneId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
}

// DescribePageFaceVerifyDataResponse is the response struct for api DescribePageFaceVerifyData
type DescribePageFaceVerifyDataResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	Success     string      `json:"Success" xml:"Success"`
	Code        string      `json:"Code" xml:"Code"`
	Message     string      `json:"Message" xml:"Message"`
	TotalCount  string      `json:"TotalCount" xml:"TotalCount"`
	PageSize    string      `json:"PageSize" xml:"PageSize"`
	TotalPage   string      `json:"TotalPage" xml:"TotalPage"`
	CurrentPage string      `json:"CurrentPage" xml:"CurrentPage"`
	Items       []ItemsItem `json:"Items" xml:"Items"`
}

// CreateDescribePageFaceVerifyDataRequest creates a request to invoke DescribePageFaceVerifyData API
func CreateDescribePageFaceVerifyDataRequest() (request *DescribePageFaceVerifyDataRequest) {
	request = &DescribePageFaceVerifyDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "DescribePageFaceVerifyData", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePageFaceVerifyDataResponse creates a response to parse from DescribePageFaceVerifyData response
func CreateDescribePageFaceVerifyDataResponse() (response *DescribePageFaceVerifyDataResponse) {
	response = &DescribePageFaceVerifyDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
