package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetItemMaterial invokes the cloudesl.GetItemMaterial API synchronously
func (client *Client) GetItemMaterial(request *GetItemMaterialRequest) (response *GetItemMaterialResponse, err error) {
	response = CreateGetItemMaterialResponse()
	err = client.DoAction(request, response)
	return
}

// GetItemMaterialWithChan invokes the cloudesl.GetItemMaterial API asynchronously
func (client *Client) GetItemMaterialWithChan(request *GetItemMaterialRequest) (<-chan *GetItemMaterialResponse, <-chan error) {
	responseChan := make(chan *GetItemMaterialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetItemMaterial(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetItemMaterialWithCallback invokes the cloudesl.GetItemMaterial API asynchronously
func (client *Client) GetItemMaterialWithCallback(request *GetItemMaterialRequest, callback func(response *GetItemMaterialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetItemMaterialResponse
		var err error
		defer close(result)
		response, err = client.GetItemMaterial(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetItemMaterialRequest is the request struct for api GetItemMaterial
type GetItemMaterialRequest struct {
	*requests.RpcRequest
	BarCode string `position:"Body" name:"BarCode"`
}

// GetItemMaterialResponse is the response struct for api GetItemMaterial
type GetItemMaterialResponse struct {
	*responses.BaseResponse
	RequestId      string       `json:"RequestId" xml:"RequestId"`
	Success        bool         `json:"Success" xml:"Success"`
	Message        string       `json:"Message" xml:"Message"`
	ErrorCode      string       `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string       `json:"ErrorMessage" xml:"ErrorMessage"`
	Code           string       `json:"Code" xml:"Code"`
	DynamicCode    string       `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string       `json:"DynamicMessage" xml:"DynamicMessage"`
	MaterialInfo   MaterialInfo `json:"MaterialInfo" xml:"MaterialInfo"`
}

// CreateGetItemMaterialRequest creates a request to invoke GetItemMaterial API
func CreateGetItemMaterialRequest() (request *GetItemMaterialRequest) {
	request = &GetItemMaterialRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "GetItemMaterial", "", "")
	request.Method = requests.POST
	return
}

// CreateGetItemMaterialResponse creates a response to parse from GetItemMaterial response
func CreateGetItemMaterialResponse() (response *GetItemMaterialResponse) {
	response = &GetItemMaterialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
