package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateNatFirewallControlPolicy invokes the cloudfw.CreateNatFirewallControlPolicy API synchronously
func (client *Client) CreateNatFirewallControlPolicy(request *CreateNatFirewallControlPolicyRequest) (response *CreateNatFirewallControlPolicyResponse, err error) {
	response = CreateCreateNatFirewallControlPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// CreateNatFirewallControlPolicyWithChan invokes the cloudfw.CreateNatFirewallControlPolicy API asynchronously
func (client *Client) CreateNatFirewallControlPolicyWithChan(request *CreateNatFirewallControlPolicyRequest) (<-chan *CreateNatFirewallControlPolicyResponse, <-chan error) {
	responseChan := make(chan *CreateNatFirewallControlPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateNatFirewallControlPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateNatFirewallControlPolicyWithCallback invokes the cloudfw.CreateNatFirewallControlPolicy API asynchronously
func (client *Client) CreateNatFirewallControlPolicyWithCallback(request *CreateNatFirewallControlPolicyRequest, callback func(response *CreateNatFirewallControlPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateNatFirewallControlPolicyResponse
		var err error
		defer close(result)
		response, err = client.CreateNatFirewallControlPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateNatFirewallControlPolicyRequest is the request struct for api CreateNatFirewallControlPolicy
type CreateNatFirewallControlPolicyRequest struct {
	*requests.RpcRequest
	DestPortType        string           `position:"Query" name:"DestPortType"`
	Release             string           `position:"Query" name:"Release"`
	Destination         string           `position:"Query" name:"Destination"`
	DestinationType     string           `position:"Query" name:"DestinationType"`
	DestPortGroup       string           `position:"Query" name:"DestPortGroup"`
	ApplicationNameList *[]string        `position:"Query" name:"ApplicationNameList"  type:"Repeated"`
	Description         string           `position:"Query" name:"Description"`
	Source              string           `position:"Query" name:"Source"`
	AclAction           string           `position:"Query" name:"AclAction"`
	SourceIp            string           `position:"Query" name:"SourceIp"`
	NewOrder            string           `position:"Query" name:"NewOrder"`
	SourceType          string           `position:"Query" name:"SourceType"`
	NatGatewayId        string           `position:"Query" name:"NatGatewayId"`
	IpVersion           string           `position:"Query" name:"IpVersion"`
	Lang                string           `position:"Query" name:"Lang"`
	Direction           string           `position:"Query" name:"Direction"`
	DomainResolveType   requests.Integer `position:"Query" name:"DomainResolveType"`
	Proto               string           `position:"Query" name:"Proto"`
	DestPort            string           `position:"Query" name:"DestPort"`
}

// CreateNatFirewallControlPolicyResponse is the response struct for api CreateNatFirewallControlPolicy
type CreateNatFirewallControlPolicyResponse struct {
	*responses.BaseResponse
	AclUuid   string `json:"AclUuid" xml:"AclUuid"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateNatFirewallControlPolicyRequest creates a request to invoke CreateNatFirewallControlPolicy API
func CreateCreateNatFirewallControlPolicyRequest() (request *CreateNatFirewallControlPolicyRequest) {
	request = &CreateNatFirewallControlPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "CreateNatFirewallControlPolicy", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateNatFirewallControlPolicyResponse creates a response to parse from CreateNatFirewallControlPolicy response
func CreateCreateNatFirewallControlPolicyResponse() (response *CreateNatFirewallControlPolicyResponse) {
	response = &CreateNatFirewallControlPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
