package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePolicyPriorUsed invokes the cloudfw.DescribePolicyPriorUsed API synchronously
func (client *Client) DescribePolicyPriorUsed(request *DescribePolicyPriorUsedRequest) (response *DescribePolicyPriorUsedResponse, err error) {
	response = CreateDescribePolicyPriorUsedResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePolicyPriorUsedWithChan invokes the cloudfw.DescribePolicyPriorUsed API asynchronously
func (client *Client) DescribePolicyPriorUsedWithChan(request *DescribePolicyPriorUsedRequest) (<-chan *DescribePolicyPriorUsedResponse, <-chan error) {
	responseChan := make(chan *DescribePolicyPriorUsedResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePolicyPriorUsed(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePolicyPriorUsedWithCallback invokes the cloudfw.DescribePolicyPriorUsed API asynchronously
func (client *Client) DescribePolicyPriorUsedWithCallback(request *DescribePolicyPriorUsedRequest, callback func(response *DescribePolicyPriorUsedResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePolicyPriorUsedResponse
		var err error
		defer close(result)
		response, err = client.DescribePolicyPriorUsed(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePolicyPriorUsedRequest is the request struct for api DescribePolicyPriorUsed
type DescribePolicyPriorUsedRequest struct {
	*requests.RpcRequest
	SourceIp  string `position:"Query" name:"SourceIp"`
	IpVersion string `position:"Query" name:"IpVersion"`
	Lang      string `position:"Query" name:"Lang"`
	Direction string `position:"Query" name:"Direction"`
}

// DescribePolicyPriorUsedResponse is the response struct for api DescribePolicyPriorUsed
type DescribePolicyPriorUsedResponse struct {
	*responses.BaseResponse
	End       int    `json:"End" xml:"End"`
	Start     int    `json:"Start" xml:"Start"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribePolicyPriorUsedRequest creates a request to invoke DescribePolicyPriorUsed API
func CreateDescribePolicyPriorUsedRequest() (request *DescribePolicyPriorUsedRequest) {
	request = &DescribePolicyPriorUsedRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribePolicyPriorUsed", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePolicyPriorUsedResponse creates a response to parse from DescribePolicyPriorUsed response
func CreateDescribePolicyPriorUsedResponse() (response *DescribePolicyPriorUsedResponse) {
	response = &DescribePolicyPriorUsedResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
