package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVpcFirewallDetail invokes the cloudfw.DescribeVpcFirewallDetail API synchronously
func (client *Client) DescribeVpcFirewallDetail(request *DescribeVpcFirewallDetailRequest) (response *DescribeVpcFirewallDetailResponse, err error) {
	response = CreateDescribeVpcFirewallDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVpcFirewallDetailWithChan invokes the cloudfw.DescribeVpcFirewallDetail API asynchronously
func (client *Client) DescribeVpcFirewallDetailWithChan(request *DescribeVpcFirewallDetailRequest) (<-chan *DescribeVpcFirewallDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeVpcFirewallDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVpcFirewallDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVpcFirewallDetailWithCallback invokes the cloudfw.DescribeVpcFirewallDetail API asynchronously
func (client *Client) DescribeVpcFirewallDetailWithCallback(request *DescribeVpcFirewallDetailRequest, callback func(response *DescribeVpcFirewallDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVpcFirewallDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeVpcFirewallDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVpcFirewallDetailRequest is the request struct for api DescribeVpcFirewallDetail
type DescribeVpcFirewallDetailRequest struct {
	*requests.RpcRequest
	LocalVpcId    string `position:"Query" name:"LocalVpcId"`
	SourceIp      string `position:"Query" name:"SourceIp"`
	PeerVpcId     string `position:"Query" name:"PeerVpcId"`
	Lang          string `position:"Query" name:"Lang"`
	VpcFirewallId string `position:"Query" name:"VpcFirewallId"`
}

// DescribeVpcFirewallDetailResponse is the response struct for api DescribeVpcFirewallDetail
type DescribeVpcFirewallDetailResponse struct {
	*responses.BaseResponse
	ConnectType          string   `json:"ConnectType" xml:"ConnectType"`
	VpcFirewallId        string   `json:"VpcFirewallId" xml:"VpcFirewallId"`
	RequestId            string   `json:"RequestId" xml:"RequestId"`
	Bandwidth            int      `json:"Bandwidth" xml:"Bandwidth"`
	VpcFirewallName      string   `json:"VpcFirewallName" xml:"VpcFirewallName"`
	FirewallSwitchStatus string   `json:"FirewallSwitchStatus" xml:"FirewallSwitchStatus"`
	MemberUid            string   `json:"MemberUid" xml:"MemberUid"`
	LocalVpc             LocalVpc `json:"LocalVpc" xml:"LocalVpc"`
	PeerVpc              PeerVpc  `json:"PeerVpc" xml:"PeerVpc"`
}

// CreateDescribeVpcFirewallDetailRequest creates a request to invoke DescribeVpcFirewallDetail API
func CreateDescribeVpcFirewallDetailRequest() (request *DescribeVpcFirewallDetailRequest) {
	request = &DescribeVpcFirewallDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeVpcFirewallDetail", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVpcFirewallDetailResponse creates a response to parse from DescribeVpcFirewallDetail response
func CreateDescribeVpcFirewallDetailResponse() (response *DescribeVpcFirewallDetailResponse) {
	response = &DescribeVpcFirewallDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
