package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyVpcFirewallControlPolicyPosition invokes the cloudfw.ModifyVpcFirewallControlPolicyPosition API synchronously
func (client *Client) ModifyVpcFirewallControlPolicyPosition(request *ModifyVpcFirewallControlPolicyPositionRequest) (response *ModifyVpcFirewallControlPolicyPositionResponse, err error) {
	response = CreateModifyVpcFirewallControlPolicyPositionResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyVpcFirewallControlPolicyPositionWithChan invokes the cloudfw.ModifyVpcFirewallControlPolicyPosition API asynchronously
func (client *Client) ModifyVpcFirewallControlPolicyPositionWithChan(request *ModifyVpcFirewallControlPolicyPositionRequest) (<-chan *ModifyVpcFirewallControlPolicyPositionResponse, <-chan error) {
	responseChan := make(chan *ModifyVpcFirewallControlPolicyPositionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyVpcFirewallControlPolicyPosition(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyVpcFirewallControlPolicyPositionWithCallback invokes the cloudfw.ModifyVpcFirewallControlPolicyPosition API asynchronously
func (client *Client) ModifyVpcFirewallControlPolicyPositionWithCallback(request *ModifyVpcFirewallControlPolicyPositionRequest, callback func(response *ModifyVpcFirewallControlPolicyPositionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyVpcFirewallControlPolicyPositionResponse
		var err error
		defer close(result)
		response, err = client.ModifyVpcFirewallControlPolicyPosition(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyVpcFirewallControlPolicyPositionRequest is the request struct for api ModifyVpcFirewallControlPolicyPosition
type ModifyVpcFirewallControlPolicyPositionRequest struct {
	*requests.RpcRequest
	AclUuid       string `position:"Query" name:"AclUuid"`
	SourceIp      string `position:"Query" name:"SourceIp"`
	NewOrder      string `position:"Query" name:"NewOrder"`
	Lang          string `position:"Query" name:"Lang"`
	VpcFirewallId string `position:"Query" name:"VpcFirewallId"`
	OldOrder      string `position:"Query" name:"OldOrder"`
}

// ModifyVpcFirewallControlPolicyPositionResponse is the response struct for api ModifyVpcFirewallControlPolicyPosition
type ModifyVpcFirewallControlPolicyPositionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyVpcFirewallControlPolicyPositionRequest creates a request to invoke ModifyVpcFirewallControlPolicyPosition API
func CreateModifyVpcFirewallControlPolicyPositionRequest() (request *ModifyVpcFirewallControlPolicyPositionRequest) {
	request = &ModifyVpcFirewallControlPolicyPositionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "ModifyVpcFirewallControlPolicyPosition", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyVpcFirewallControlPolicyPositionResponse creates a response to parse from ModifyVpcFirewallControlPolicyPosition response
func CreateModifyVpcFirewallControlPolicyPositionResponse() (response *ModifyVpcFirewallControlPolicyPositionResponse) {
	response = &ModifyVpcFirewallControlPolicyPositionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
