package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMonitorGroupInstances invokes the cms.DeleteMonitorGroupInstances API synchronously
func (client *Client) DeleteMonitorGroupInstances(request *DeleteMonitorGroupInstancesRequest) (response *DeleteMonitorGroupInstancesResponse, err error) {
	response = CreateDeleteMonitorGroupInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMonitorGroupInstancesWithChan invokes the cms.DeleteMonitorGroupInstances API asynchronously
func (client *Client) DeleteMonitorGroupInstancesWithChan(request *DeleteMonitorGroupInstancesRequest) (<-chan *DeleteMonitorGroupInstancesResponse, <-chan error) {
	responseChan := make(chan *DeleteMonitorGroupInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMonitorGroupInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMonitorGroupInstancesWithCallback invokes the cms.DeleteMonitorGroupInstances API asynchronously
func (client *Client) DeleteMonitorGroupInstancesWithCallback(request *DeleteMonitorGroupInstancesRequest, callback func(response *DeleteMonitorGroupInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMonitorGroupInstancesResponse
		var err error
		defer close(result)
		response, err = client.DeleteMonitorGroupInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMonitorGroupInstancesRequest is the request struct for api DeleteMonitorGroupInstances
type DeleteMonitorGroupInstancesRequest struct {
	*requests.RpcRequest
	GroupId        requests.Integer `position:"Query" name:"GroupId"`
	InstanceIdList string           `position:"Query" name:"InstanceIdList"`
	Category       string           `position:"Query" name:"Category"`
}

// DeleteMonitorGroupInstancesResponse is the response struct for api DeleteMonitorGroupInstances
type DeleteMonitorGroupInstancesResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteMonitorGroupInstancesRequest creates a request to invoke DeleteMonitorGroupInstances API
func CreateDeleteMonitorGroupInstancesRequest() (request *DeleteMonitorGroupInstancesRequest) {
	request = &DeleteMonitorGroupInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DeleteMonitorGroupInstances", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteMonitorGroupInstancesResponse creates a response to parse from DeleteMonitorGroupInstances response
func CreateDeleteMonitorGroupInstancesResponse() (response *DeleteMonitorGroupInstancesResponse) {
	response = &DeleteMonitorGroupInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
