package computenestsupplier

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListArtifactVersions invokes the computenestsupplier.ListArtifactVersions API synchronously
func (client *Client) ListArtifactVersions(request *ListArtifactVersionsRequest) (response *ListArtifactVersionsResponse, err error) {
	response = CreateListArtifactVersionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListArtifactVersionsWithChan invokes the computenestsupplier.ListArtifactVersions API asynchronously
func (client *Client) ListArtifactVersionsWithChan(request *ListArtifactVersionsRequest) (<-chan *ListArtifactVersionsResponse, <-chan error) {
	responseChan := make(chan *ListArtifactVersionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListArtifactVersions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListArtifactVersionsWithCallback invokes the computenestsupplier.ListArtifactVersions API asynchronously
func (client *Client) ListArtifactVersionsWithCallback(request *ListArtifactVersionsRequest, callback func(response *ListArtifactVersionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListArtifactVersionsResponse
		var err error
		defer close(result)
		response, err = client.ListArtifactVersions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListArtifactVersionsRequest is the request struct for api ListArtifactVersions
type ListArtifactVersionsRequest struct {
	*requests.RpcRequest
	NextToken  string           `position:"Query" name:"NextToken"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
	ArtifactId string           `position:"Query" name:"ArtifactId"`
}

// ListArtifactVersionsResponse is the response struct for api ListArtifactVersions
type ListArtifactVersionsResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	NextToken  string     `json:"NextToken" xml:"NextToken"`
	MaxResults int        `json:"MaxResults" xml:"MaxResults"`
	TotalCount int        `json:"TotalCount" xml:"TotalCount"`
	Artifacts  []Artifact `json:"Artifacts" xml:"Artifacts"`
}

// CreateListArtifactVersionsRequest creates a request to invoke ListArtifactVersions API
func CreateListArtifactVersionsRequest() (request *ListArtifactVersionsRequest) {
	request = &ListArtifactVersionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNestSupplier", "2021-05-21", "ListArtifactVersions", "", "")
	request.Method = requests.POST
	return
}

// CreateListArtifactVersionsResponse creates a response to parse from ListArtifactVersions response
func CreateListArtifactVersionsResponse() (response *ListArtifactVersionsResponse) {
	response = &ListArtifactVersionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
