package computenestsupplier

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RegisterService invokes the computenestsupplier.RegisterService API synchronously
func (client *Client) RegisterService(request *RegisterServiceRequest) (response *RegisterServiceResponse, err error) {
	response = CreateRegisterServiceResponse()
	err = client.DoAction(request, response)
	return
}

// RegisterServiceWithChan invokes the computenestsupplier.RegisterService API asynchronously
func (client *Client) RegisterServiceWithChan(request *RegisterServiceRequest) (<-chan *RegisterServiceResponse, <-chan error) {
	responseChan := make(chan *RegisterServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RegisterService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RegisterServiceWithCallback invokes the computenestsupplier.RegisterService API asynchronously
func (client *Client) RegisterServiceWithCallback(request *RegisterServiceRequest, callback func(response *RegisterServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RegisterServiceResponse
		var err error
		defer close(result)
		response, err = client.RegisterService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RegisterServiceRequest is the request struct for api RegisterService
type RegisterServiceRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	ServiceId   string `position:"Query" name:"ServiceId"`
}

// RegisterServiceResponse is the response struct for api RegisterService
type RegisterServiceResponse struct {
	*responses.BaseResponse
	RegistrationId string `json:"RegistrationId" xml:"RegistrationId"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateRegisterServiceRequest creates a request to invoke RegisterService API
func CreateRegisterServiceRequest() (request *RegisterServiceRequest) {
	request = &RegisterServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNestSupplier", "2021-05-21", "RegisterService", "", "")
	request.Method = requests.POST
	return
}

// CreateRegisterServiceResponse creates a response to parse from RegisterService response
func CreateRegisterServiceResponse() (response *RegisterServiceResponse) {
	response = &RegisterServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
