package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutEvaluations invokes the config.PutEvaluations API synchronously
func (client *Client) PutEvaluations(request *PutEvaluationsRequest) (response *PutEvaluationsResponse, err error) {
	response = CreatePutEvaluationsResponse()
	err = client.DoAction(request, response)
	return
}

// PutEvaluationsWithChan invokes the config.PutEvaluations API asynchronously
func (client *Client) PutEvaluationsWithChan(request *PutEvaluationsRequest) (<-chan *PutEvaluationsResponse, <-chan error) {
	responseChan := make(chan *PutEvaluationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutEvaluations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutEvaluationsWithCallback invokes the config.PutEvaluations API asynchronously
func (client *Client) PutEvaluationsWithCallback(request *PutEvaluationsRequest, callback func(response *PutEvaluationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutEvaluationsResponse
		var err error
		defer close(result)
		response, err = client.PutEvaluations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutEvaluationsRequest is the request struct for api PutEvaluations
type PutEvaluationsRequest struct {
	*requests.RpcRequest
	Evaluations string           `position:"Body" name:"Evaluations"`
	DeleteMode  requests.Boolean `position:"Body" name:"DeleteMode"`
	ResultToken string           `position:"Body" name:"ResultToken"`
}

// PutEvaluationsResponse is the response struct for api PutEvaluations
type PutEvaluationsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreatePutEvaluationsRequest creates a request to invoke PutEvaluations API
func CreatePutEvaluationsRequest() (request *PutEvaluationsRequest) {
	request = &PutEvaluationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "PutEvaluations", "", "")
	request.Method = requests.POST
	return
}

// CreatePutEvaluationsResponse creates a response to parse from PutEvaluations response
func CreatePutEvaluationsResponse() (response *PutEvaluationsResponse) {
	response = &PutEvaluationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
