package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateIdpDepartment invokes the csas.CreateIdpDepartment API synchronously
func (client *Client) CreateIdpDepartment(request *CreateIdpDepartmentRequest) (response *CreateIdpDepartmentResponse, err error) {
	response = CreateCreateIdpDepartmentResponse()
	err = client.DoAction(request, response)
	return
}

// CreateIdpDepartmentWithChan invokes the csas.CreateIdpDepartment API asynchronously
func (client *Client) CreateIdpDepartmentWithChan(request *CreateIdpDepartmentRequest) (<-chan *CreateIdpDepartmentResponse, <-chan error) {
	responseChan := make(chan *CreateIdpDepartmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateIdpDepartment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateIdpDepartmentWithCallback invokes the csas.CreateIdpDepartment API asynchronously
func (client *Client) CreateIdpDepartmentWithCallback(request *CreateIdpDepartmentRequest, callback func(response *CreateIdpDepartmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateIdpDepartmentResponse
		var err error
		defer close(result)
		response, err = client.CreateIdpDepartment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateIdpDepartmentRequest is the request struct for api CreateIdpDepartment
type CreateIdpDepartmentRequest struct {
	*requests.RpcRequest
	IdpConfigId    string `position:"Query" name:"IdpConfigId"`
	DepartmentName string `position:"Query" name:"DepartmentName"`
}

// CreateIdpDepartmentResponse is the response struct for api CreateIdpDepartment
type CreateIdpDepartmentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateCreateIdpDepartmentRequest creates a request to invoke CreateIdpDepartment API
func CreateCreateIdpDepartmentRequest() (request *CreateIdpDepartmentRequest) {
	request = &CreateIdpDepartmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "CreateIdpDepartment", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateIdpDepartmentResponse creates a response to parse from CreateIdpDepartment response
func CreateCreateIdpDepartmentResponse() (response *CreateIdpDepartmentResponse) {
	response = &CreateIdpDepartmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
