package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApprovals invokes the csas.ListApprovals API synchronously
func (client *Client) ListApprovals(request *ListApprovalsRequest) (response *ListApprovalsResponse, err error) {
	response = CreateListApprovalsResponse()
	err = client.DoAction(request, response)
	return
}

// ListApprovalsWithChan invokes the csas.ListApprovals API asynchronously
func (client *Client) ListApprovalsWithChan(request *ListApprovalsRequest) (<-chan *ListApprovalsResponse, <-chan error) {
	responseChan := make(chan *ListApprovalsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApprovals(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApprovalsWithCallback invokes the csas.ListApprovals API asynchronously
func (client *Client) ListApprovalsWithCallback(request *ListApprovalsRequest, callback func(response *ListApprovalsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApprovalsResponse
		var err error
		defer close(result)
		response, err = client.ListApprovals(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApprovalsRequest is the request struct for api ListApprovals
type ListApprovalsRequest struct {
	*requests.RpcRequest
	SourceIp          string           `position:"Query" name:"SourceIp"`
	SchemaId          string           `position:"Query" name:"SchemaId"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
	CreateEndTime     requests.Integer `position:"Query" name:"CreateEndTime"`
	OperatorUserId    string           `position:"Query" name:"OperatorUserId"`
	SchemaName        string           `position:"Query" name:"SchemaName"`
	PolicyType        string           `position:"Query" name:"PolicyType"`
	ProcessName       string           `position:"Query" name:"ProcessName"`
	CurrentPage       requests.Integer `position:"Query" name:"CurrentPage"`
	ApprovalIds       *[]string        `position:"Query" name:"ApprovalIds"  type:"Repeated"`
	CreateStartTime   requests.Integer `position:"Query" name:"CreateStartTime"`
	ProcessId         string           `position:"Query" name:"ProcessId"`
	CreatorDepartment string           `position:"Query" name:"CreatorDepartment"`
	OperatorUsername  string           `position:"Query" name:"OperatorUsername"`
	CreatorUserId     string           `position:"Query" name:"CreatorUserId"`
	CreatorUsername   string           `position:"Query" name:"CreatorUsername"`
	Statuses          *[]string        `position:"Query" name:"Statuses"  type:"Repeated"`
	CreatorDevTag     string           `position:"Query" name:"CreatorDevTag"`
}

// ListApprovalsResponse is the response struct for api ListApprovals
type ListApprovalsResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	TotalNum  string     `json:"TotalNum" xml:"TotalNum"`
	Approvals []DataList `json:"Approvals" xml:"Approvals"`
}

// CreateListApprovalsRequest creates a request to invoke ListApprovals API
func CreateListApprovalsRequest() (request *ListApprovalsRequest) {
	request = &ListApprovalsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListApprovals", "", "")
	request.Method = requests.GET
	return
}

// CreateListApprovalsResponse creates a response to parse from ListApprovals response
func CreateListApprovalsResponse() (response *ListApprovalsResponse) {
	response = &ListApprovalsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
