package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListConnectors invokes the csas.ListConnectors API synchronously
func (client *Client) ListConnectors(request *ListConnectorsRequest) (response *ListConnectorsResponse, err error) {
	response = CreateListConnectorsResponse()
	err = client.DoAction(request, response)
	return
}

// ListConnectorsWithChan invokes the csas.ListConnectors API asynchronously
func (client *Client) ListConnectorsWithChan(request *ListConnectorsRequest) (<-chan *ListConnectorsResponse, <-chan error) {
	responseChan := make(chan *ListConnectorsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListConnectors(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListConnectorsWithCallback invokes the csas.ListConnectors API asynchronously
func (client *Client) ListConnectorsWithCallback(request *ListConnectorsRequest, callback func(response *ListConnectorsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListConnectorsResponse
		var err error
		defer close(result)
		response, err = client.ListConnectors(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListConnectorsRequest is the request struct for api ListConnectors
type ListConnectorsRequest struct {
	*requests.RpcRequest
	SwitchStatus string           `position:"Query" name:"SwitchStatus"`
	SourceIp     string           `position:"Query" name:"SourceIp"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage  requests.Integer `position:"Query" name:"CurrentPage"`
	Name         string           `position:"Query" name:"Name"`
	ConnectorIds *[]string        `position:"Query" name:"ConnectorIds"  type:"Repeated"`
	Status       string           `position:"Query" name:"Status"`
}

// ListConnectorsResponse is the response struct for api ListConnectors
type ListConnectorsResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	TotalNum   int         `json:"TotalNum" xml:"TotalNum"`
	Connectors []Connector `json:"Connectors" xml:"Connectors"`
}

// CreateListConnectorsRequest creates a request to invoke ListConnectors API
func CreateListConnectorsRequest() (request *ListConnectorsRequest) {
	request = &ListConnectorsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListConnectors", "", "")
	request.Method = requests.GET
	return
}

// CreateListConnectorsResponse creates a response to parse from ListConnectors response
func CreateListConnectorsResponse() (response *ListConnectorsResponse) {
	response = &ListConnectorsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
