package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDynamicRouteRegions invokes the csas.ListDynamicRouteRegions API synchronously
func (client *Client) ListDynamicRouteRegions(request *ListDynamicRouteRegionsRequest) (response *ListDynamicRouteRegionsResponse, err error) {
	response = CreateListDynamicRouteRegionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDynamicRouteRegionsWithChan invokes the csas.ListDynamicRouteRegions API asynchronously
func (client *Client) ListDynamicRouteRegionsWithChan(request *ListDynamicRouteRegionsRequest) (<-chan *ListDynamicRouteRegionsResponse, <-chan error) {
	responseChan := make(chan *ListDynamicRouteRegionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDynamicRouteRegions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDynamicRouteRegionsWithCallback invokes the csas.ListDynamicRouteRegions API asynchronously
func (client *Client) ListDynamicRouteRegionsWithCallback(request *ListDynamicRouteRegionsRequest, callback func(response *ListDynamicRouteRegionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDynamicRouteRegionsResponse
		var err error
		defer close(result)
		response, err = client.ListDynamicRouteRegions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDynamicRouteRegionsRequest is the request struct for api ListDynamicRouteRegions
type ListDynamicRouteRegionsRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// ListDynamicRouteRegionsResponse is the response struct for api ListDynamicRouteRegions
type ListDynamicRouteRegionsResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	TotalNum  int      `json:"TotalNum" xml:"TotalNum"`
	Regions   []string `json:"Regions" xml:"Regions"`
}

// CreateListDynamicRouteRegionsRequest creates a request to invoke ListDynamicRouteRegions API
func CreateListDynamicRouteRegionsRequest() (request *ListDynamicRouteRegionsRequest) {
	request = &ListDynamicRouteRegionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListDynamicRouteRegions", "", "")
	request.Method = requests.GET
	return
}

// CreateListDynamicRouteRegionsResponse creates a response to parse from ListDynamicRouteRegions response
func CreateListDynamicRouteRegionsResponse() (response *ListDynamicRouteRegionsResponse) {
	response = &ListDynamicRouteRegionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
