package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateKillInstanceSessionTask invokes the das.CreateKillInstanceSessionTask API synchronously
func (client *Client) CreateKillInstanceSessionTask(request *CreateKillInstanceSessionTaskRequest) (response *CreateKillInstanceSessionTaskResponse, err error) {
	response = CreateCreateKillInstanceSessionTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateKillInstanceSessionTaskWithChan invokes the das.CreateKillInstanceSessionTask API asynchronously
func (client *Client) CreateKillInstanceSessionTaskWithChan(request *CreateKillInstanceSessionTaskRequest) (<-chan *CreateKillInstanceSessionTaskResponse, <-chan error) {
	responseChan := make(chan *CreateKillInstanceSessionTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateKillInstanceSessionTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateKillInstanceSessionTaskWithCallback invokes the das.CreateKillInstanceSessionTask API asynchronously
func (client *Client) CreateKillInstanceSessionTaskWithCallback(request *CreateKillInstanceSessionTaskRequest, callback func(response *CreateKillInstanceSessionTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateKillInstanceSessionTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateKillInstanceSessionTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateKillInstanceSessionTaskRequest is the request struct for api CreateKillInstanceSessionTask
type CreateKillInstanceSessionTaskRequest struct {
	*requests.RpcRequest
	KillAllSessions requests.Boolean `position:"Query" name:"KillAllSessions"`
	DbUser          string           `position:"Query" name:"DbUser"`
	SessionIds      string           `position:"Query" name:"SessionIds"`
	DbUserPassword  string           `position:"Query" name:"DbUserPassword"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	IgnoredUsers    string           `position:"Query" name:"IgnoredUsers"`
	NodeId          string           `position:"Query" name:"NodeId"`
}

// CreateKillInstanceSessionTaskResponse is the response struct for api CreateKillInstanceSessionTask
type CreateKillInstanceSessionTaskResponse struct {
	*responses.BaseResponse
	Code      int64  `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCreateKillInstanceSessionTaskRequest creates a request to invoke CreateKillInstanceSessionTask API
func CreateCreateKillInstanceSessionTaskRequest() (request *CreateKillInstanceSessionTaskRequest) {
	request = &CreateKillInstanceSessionTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "CreateKillInstanceSessionTask", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateKillInstanceSessionTaskResponse creates a response to parse from CreateKillInstanceSessionTask response
func CreateCreateKillInstanceSessionTaskResponse() (response *CreateKillInstanceSessionTaskResponse) {
	response = &CreateKillInstanceSessionTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
