package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnBgpTrafficData invokes the dcdn.DescribeDcdnBgpTrafficData API synchronously
func (client *Client) DescribeDcdnBgpTrafficData(request *DescribeDcdnBgpTrafficDataRequest) (response *DescribeDcdnBgpTrafficDataResponse, err error) {
	response = CreateDescribeDcdnBgpTrafficDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnBgpTrafficDataWithChan invokes the dcdn.DescribeDcdnBgpTrafficData API asynchronously
func (client *Client) DescribeDcdnBgpTrafficDataWithChan(request *DescribeDcdnBgpTrafficDataRequest) (<-chan *DescribeDcdnBgpTrafficDataResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnBgpTrafficDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnBgpTrafficData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnBgpTrafficDataWithCallback invokes the dcdn.DescribeDcdnBgpTrafficData API asynchronously
func (client *Client) DescribeDcdnBgpTrafficDataWithCallback(request *DescribeDcdnBgpTrafficDataRequest, callback func(response *DescribeDcdnBgpTrafficDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnBgpTrafficDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnBgpTrafficData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnBgpTrafficDataRequest is the request struct for api DescribeDcdnBgpTrafficData
type DescribeDcdnBgpTrafficDataRequest struct {
	*requests.RpcRequest
	Isp       string `position:"Query" name:"Isp"`
	EndTime   string `position:"Query" name:"EndTime"`
	Interval  string `position:"Query" name:"Interval"`
	StartTime string `position:"Query" name:"StartTime"`
}

// DescribeDcdnBgpTrafficDataResponse is the response struct for api DescribeDcdnBgpTrafficData
type DescribeDcdnBgpTrafficDataResponse struct {
	*responses.BaseResponse
	EndTime         string                                `json:"EndTime" xml:"EndTime"`
	StartTime       string                                `json:"StartTime" xml:"StartTime"`
	RequestId       string                                `json:"RequestId" xml:"RequestId"`
	BgpDataInterval []BgpDataInDescribeDcdnBgpTrafficData `json:"BgpDataInterval" xml:"BgpDataInterval"`
}

// CreateDescribeDcdnBgpTrafficDataRequest creates a request to invoke DescribeDcdnBgpTrafficData API
func CreateDescribeDcdnBgpTrafficDataRequest() (request *DescribeDcdnBgpTrafficDataRequest) {
	request = &DescribeDcdnBgpTrafficDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnBgpTrafficData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnBgpTrafficDataResponse creates a response to parse from DescribeDcdnBgpTrafficData response
func CreateDescribeDcdnBgpTrafficDataResponse() (response *DescribeDcdnBgpTrafficDataResponse) {
	response = &DescribeDcdnBgpTrafficDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
