package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnDomainsBySource invokes the dcdn.DescribeDcdnDomainsBySource API synchronously
func (client *Client) DescribeDcdnDomainsBySource(request *DescribeDcdnDomainsBySourceRequest) (response *DescribeDcdnDomainsBySourceResponse, err error) {
	response = CreateDescribeDcdnDomainsBySourceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnDomainsBySourceWithChan invokes the dcdn.DescribeDcdnDomainsBySource API asynchronously
func (client *Client) DescribeDcdnDomainsBySourceWithChan(request *DescribeDcdnDomainsBySourceRequest) (<-chan *DescribeDcdnDomainsBySourceResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnDomainsBySourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnDomainsBySource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnDomainsBySourceWithCallback invokes the dcdn.DescribeDcdnDomainsBySource API asynchronously
func (client *Client) DescribeDcdnDomainsBySourceWithCallback(request *DescribeDcdnDomainsBySourceRequest, callback func(response *DescribeDcdnDomainsBySourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnDomainsBySourceResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnDomainsBySource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnDomainsBySourceRequest is the request struct for api DescribeDcdnDomainsBySource
type DescribeDcdnDomainsBySourceRequest struct {
	*requests.RpcRequest
	Product string `position:"Query" name:"Product"`
	Sources string `position:"Query" name:"Sources"`
}

// DescribeDcdnDomainsBySourceResponse is the response struct for api DescribeDcdnDomainsBySource
type DescribeDcdnDomainsBySourceResponse struct {
	*responses.BaseResponse
	RequestId  string           `json:"RequestId" xml:"RequestId"`
	DomainInfo []DomainInfoData `json:"DomainInfo" xml:"DomainInfo"`
}

// CreateDescribeDcdnDomainsBySourceRequest creates a request to invoke DescribeDcdnDomainsBySource API
func CreateDescribeDcdnDomainsBySourceRequest() (request *DescribeDcdnDomainsBySourceRequest) {
	request = &DescribeDcdnDomainsBySourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnDomainsBySource", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnDomainsBySourceResponse creates a response to parse from DescribeDcdnDomainsBySource response
func CreateDescribeDcdnDomainsBySourceResponse() (response *DescribeDcdnDomainsBySourceResponse) {
	response = &DescribeDcdnDomainsBySourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
