package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnOriginSiteHealthStatus invokes the dcdn.DescribeDcdnOriginSiteHealthStatus API synchronously
func (client *Client) DescribeDcdnOriginSiteHealthStatus(request *DescribeDcdnOriginSiteHealthStatusRequest) (response *DescribeDcdnOriginSiteHealthStatusResponse, err error) {
	response = CreateDescribeDcdnOriginSiteHealthStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnOriginSiteHealthStatusWithChan invokes the dcdn.DescribeDcdnOriginSiteHealthStatus API asynchronously
func (client *Client) DescribeDcdnOriginSiteHealthStatusWithChan(request *DescribeDcdnOriginSiteHealthStatusRequest) (<-chan *DescribeDcdnOriginSiteHealthStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnOriginSiteHealthStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnOriginSiteHealthStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnOriginSiteHealthStatusWithCallback invokes the dcdn.DescribeDcdnOriginSiteHealthStatus API asynchronously
func (client *Client) DescribeDcdnOriginSiteHealthStatusWithCallback(request *DescribeDcdnOriginSiteHealthStatusRequest, callback func(response *DescribeDcdnOriginSiteHealthStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnOriginSiteHealthStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnOriginSiteHealthStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnOriginSiteHealthStatusRequest is the request struct for api DescribeDcdnOriginSiteHealthStatus
type DescribeDcdnOriginSiteHealthStatusRequest struct {
	*requests.RpcRequest
	DomainName string `position:"Query" name:"DomainName"`
}

// DescribeDcdnOriginSiteHealthStatusResponse is the response struct for api DescribeDcdnOriginSiteHealthStatus
type DescribeDcdnOriginSiteHealthStatusResponse struct {
	*responses.BaseResponse
	RequestId        string                 `json:"RequestId" xml:"RequestId"`
	OriginSiteStatus []OriginSiteStatusItem `json:"OriginSiteStatus" xml:"OriginSiteStatus"`
}

// CreateDescribeDcdnOriginSiteHealthStatusRequest creates a request to invoke DescribeDcdnOriginSiteHealthStatus API
func CreateDescribeDcdnOriginSiteHealthStatusRequest() (request *DescribeDcdnOriginSiteHealthStatusRequest) {
	request = &DescribeDcdnOriginSiteHealthStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnOriginSiteHealthStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnOriginSiteHealthStatusResponse creates a response to parse from DescribeDcdnOriginSiteHealthStatus response
func CreateDescribeDcdnOriginSiteHealthStatusResponse() (response *DescribeDcdnOriginSiteHealthStatusResponse) {
	response = &DescribeDcdnOriginSiteHealthStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
