package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnWafRules invokes the dcdn.DescribeDcdnWafRules API synchronously
func (client *Client) DescribeDcdnWafRules(request *DescribeDcdnWafRulesRequest) (response *DescribeDcdnWafRulesResponse, err error) {
	response = CreateDescribeDcdnWafRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnWafRulesWithChan invokes the dcdn.DescribeDcdnWafRules API asynchronously
func (client *Client) DescribeDcdnWafRulesWithChan(request *DescribeDcdnWafRulesRequest) (<-chan *DescribeDcdnWafRulesResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnWafRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnWafRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnWafRulesWithCallback invokes the dcdn.DescribeDcdnWafRules API asynchronously
func (client *Client) DescribeDcdnWafRulesWithCallback(request *DescribeDcdnWafRulesRequest, callback func(response *DescribeDcdnWafRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnWafRulesResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnWafRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnWafRulesRequest is the request struct for api DescribeDcdnWafRules
type DescribeDcdnWafRulesRequest struct {
	*requests.RpcRequest
	QueryArgs  string           `position:"Query" name:"QueryArgs"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeDcdnWafRulesResponse is the response struct for api DescribeDcdnWafRules
type DescribeDcdnWafRulesResponse struct {
	*responses.BaseResponse
	PageSize   int        `json:"PageSize" xml:"PageSize"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	PageNumber int        `json:"PageNumber" xml:"PageNumber"`
	TotalCount int        `json:"TotalCount" xml:"TotalCount"`
	Rules      []RuleItem `json:"Rules" xml:"Rules"`
}

// CreateDescribeDcdnWafRulesRequest creates a request to invoke DescribeDcdnWafRules API
func CreateDescribeDcdnWafRulesRequest() (request *DescribeDcdnWafRulesRequest) {
	request = &DescribeDcdnWafRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnWafRules", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnWafRulesResponse creates a response to parse from DescribeDcdnWafRules response
func CreateDescribeDcdnWafRulesResponse() (response *DescribeDcdnWafRulesResponse) {
	response = &DescribeDcdnWafRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
