package ddosbgp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTraffic invokes the ddosbgp.DescribeTraffic API synchronously
func (client *Client) DescribeTraffic(request *DescribeTrafficRequest) (response *DescribeTrafficResponse, err error) {
	response = CreateDescribeTrafficResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTrafficWithChan invokes the ddosbgp.DescribeTraffic API asynchronously
func (client *Client) DescribeTrafficWithChan(request *DescribeTrafficRequest) (<-chan *DescribeTrafficResponse, <-chan error) {
	responseChan := make(chan *DescribeTrafficResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTraffic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTrafficWithCallback invokes the ddosbgp.DescribeTraffic API asynchronously
func (client *Client) DescribeTrafficWithCallback(request *DescribeTrafficRequest, callback func(response *DescribeTrafficResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTrafficResponse
		var err error
		defer close(result)
		response, err = client.DescribeTraffic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTrafficRequest is the request struct for api DescribeTraffic
type DescribeTrafficRequest struct {
	*requests.RpcRequest
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Ip              string           `position:"Query" name:"Ip"`
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	Ipnet           string           `position:"Query" name:"Ipnet"`
	FlowType        string           `position:"Query" name:"FlowType"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	Interval        requests.Integer `position:"Query" name:"Interval"`
}

// DescribeTrafficResponse is the response struct for api DescribeTraffic
type DescribeTrafficResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	FlowList  []Flow `json:"FlowList" xml:"FlowList"`
}

// CreateDescribeTrafficRequest creates a request to invoke DescribeTraffic API
func CreateDescribeTrafficRequest() (request *DescribeTrafficRequest) {
	request = &DescribeTrafficRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddosbgp", "2018-07-20", "DescribeTraffic", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeTrafficResponse creates a response to parse from DescribeTraffic response
func CreateDescribeTrafficResponse() (response *DescribeTrafficResponse) {
	response = &DescribeTrafficResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
