package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLayer4RulePolicy invokes the ddoscoo.DescribeLayer4RulePolicy API synchronously
func (client *Client) DescribeLayer4RulePolicy(request *DescribeLayer4RulePolicyRequest) (response *DescribeLayer4RulePolicyResponse, err error) {
	response = CreateDescribeLayer4RulePolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLayer4RulePolicyWithChan invokes the ddoscoo.DescribeLayer4RulePolicy API asynchronously
func (client *Client) DescribeLayer4RulePolicyWithChan(request *DescribeLayer4RulePolicyRequest) (<-chan *DescribeLayer4RulePolicyResponse, <-chan error) {
	responseChan := make(chan *DescribeLayer4RulePolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLayer4RulePolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLayer4RulePolicyWithCallback invokes the ddoscoo.DescribeLayer4RulePolicy API asynchronously
func (client *Client) DescribeLayer4RulePolicyWithCallback(request *DescribeLayer4RulePolicyRequest, callback func(response *DescribeLayer4RulePolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLayer4RulePolicyResponse
		var err error
		defer close(result)
		response, err = client.DescribeLayer4RulePolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLayer4RulePolicyRequest is the request struct for api DescribeLayer4RulePolicy
type DescribeLayer4RulePolicyRequest struct {
	*requests.RpcRequest
	Listeners string `position:"Query" name:"Listeners"`
	SourceIp  string `position:"Query" name:"SourceIp"`
}

// DescribeLayer4RulePolicyResponse is the response struct for api DescribeLayer4RulePolicy
type DescribeLayer4RulePolicyResponse struct {
	*responses.BaseResponse
	FrontendPort    int                  `json:"FrontendPort" xml:"FrontendPort"`
	BakMode         string               `json:"BakMode" xml:"BakMode"`
	RequestId       string               `json:"RequestId" xml:"RequestId"`
	CurrentIndex    int                  `json:"CurrentIndex" xml:"CurrentIndex"`
	ForwardProtocol string               `json:"ForwardProtocol" xml:"ForwardProtocol"`
	InstanceId      string               `json:"InstanceId" xml:"InstanceId"`
	BackendPort     int                  `json:"BackendPort" xml:"BackendPort"`
	PriRealServers  []PriRealServersItem `json:"PriRealServers" xml:"PriRealServers"`
	SecRealServers  []SecRealServersItem `json:"SecRealServers" xml:"SecRealServers"`
}

// CreateDescribeLayer4RulePolicyRequest creates a request to invoke DescribeLayer4RulePolicy API
func CreateDescribeLayer4RulePolicyRequest() (request *DescribeLayer4RulePolicyRequest) {
	request = &DescribeLayer4RulePolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeLayer4RulePolicy", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLayer4RulePolicyResponse creates a response to parse from DescribeLayer4RulePolicy response
func CreateDescribeLayer4RulePolicyResponse() (response *DescribeLayer4RulePolicyResponse) {
	response = &DescribeLayer4RulePolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
