package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePortCcAttackTopIP invokes the ddoscoo.DescribePortCcAttackTopIP API synchronously
func (client *Client) DescribePortCcAttackTopIP(request *DescribePortCcAttackTopIPRequest) (response *DescribePortCcAttackTopIPResponse, err error) {
	response = CreateDescribePortCcAttackTopIPResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePortCcAttackTopIPWithChan invokes the ddoscoo.DescribePortCcAttackTopIP API asynchronously
func (client *Client) DescribePortCcAttackTopIPWithChan(request *DescribePortCcAttackTopIPRequest) (<-chan *DescribePortCcAttackTopIPResponse, <-chan error) {
	responseChan := make(chan *DescribePortCcAttackTopIPResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePortCcAttackTopIP(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePortCcAttackTopIPWithCallback invokes the ddoscoo.DescribePortCcAttackTopIP API asynchronously
func (client *Client) DescribePortCcAttackTopIPWithCallback(request *DescribePortCcAttackTopIPRequest, callback func(response *DescribePortCcAttackTopIPResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePortCcAttackTopIPResponse
		var err error
		defer close(result)
		response, err = client.DescribePortCcAttackTopIP(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePortCcAttackTopIPRequest is the request struct for api DescribePortCcAttackTopIP
type DescribePortCcAttackTopIPRequest struct {
	*requests.RpcRequest
	StartTimestamp requests.Integer `position:"Query" name:"StartTimestamp"`
	SourceIp       string           `position:"Query" name:"SourceIp"`
	Limit          requests.Integer `position:"Query" name:"Limit"`
	Ip             string           `position:"Query" name:"Ip"`
	Port           string           `position:"Query" name:"Port"`
}

// DescribePortCcAttackTopIPResponse is the response struct for api DescribePortCcAttackTopIP
type DescribePortCcAttackTopIPResponse struct {
	*responses.BaseResponse
	RequestId string      `json:"RequestId" xml:"RequestId"`
	TopIp     []TopIpItem `json:"TopIp" xml:"TopIp"`
}

// CreateDescribePortCcAttackTopIPRequest creates a request to invoke DescribePortCcAttackTopIP API
func CreateDescribePortCcAttackTopIPRequest() (request *DescribePortCcAttackTopIPRequest) {
	request = &DescribePortCcAttackTopIPRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribePortCcAttackTopIP", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePortCcAttackTopIPResponse creates a response to parse from DescribePortCcAttackTopIP response
func CreateDescribePortCcAttackTopIPResponse() (response *DescribePortCcAttackTopIPResponse) {
	response = &DescribePortCcAttackTopIPResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
