package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePortFlowList invokes the ddoscoo.DescribePortFlowList API synchronously
func (client *Client) DescribePortFlowList(request *DescribePortFlowListRequest) (response *DescribePortFlowListResponse, err error) {
	response = CreateDescribePortFlowListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePortFlowListWithChan invokes the ddoscoo.DescribePortFlowList API asynchronously
func (client *Client) DescribePortFlowListWithChan(request *DescribePortFlowListRequest) (<-chan *DescribePortFlowListResponse, <-chan error) {
	responseChan := make(chan *DescribePortFlowListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePortFlowList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePortFlowListWithCallback invokes the ddoscoo.DescribePortFlowList API asynchronously
func (client *Client) DescribePortFlowListWithCallback(request *DescribePortFlowListRequest, callback func(response *DescribePortFlowListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePortFlowListResponse
		var err error
		defer close(result)
		response, err = client.DescribePortFlowList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePortFlowListRequest is the request struct for api DescribePortFlowList
type DescribePortFlowListRequest struct {
	*requests.RpcRequest
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	InstanceIds     *[]string        `position:"Query" name:"InstanceIds"  type:"Repeated"`
	Interval        requests.Integer `position:"Query" name:"Interval"`
}

// DescribePortFlowListResponse is the response struct for api DescribePortFlowList
type DescribePortFlowListResponse struct {
	*responses.BaseResponse
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	PortFlowList []PortFlow `json:"PortFlowList" xml:"PortFlowList"`
}

// CreateDescribePortFlowListRequest creates a request to invoke DescribePortFlowList API
func CreateDescribePortFlowListRequest() (request *DescribePortFlowListRequest) {
	request = &DescribePortFlowListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribePortFlowList", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePortFlowListResponse creates a response to parse from DescribePortFlowList response
func CreateDescribePortFlowListResponse() (response *DescribePortFlowListResponse) {
	response = &DescribePortFlowListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
