package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTagKeys invokes the ddoscoo.DescribeTagKeys API synchronously
func (client *Client) DescribeTagKeys(request *DescribeTagKeysRequest) (response *DescribeTagKeysResponse, err error) {
	response = CreateDescribeTagKeysResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTagKeysWithChan invokes the ddoscoo.DescribeTagKeys API asynchronously
func (client *Client) DescribeTagKeysWithChan(request *DescribeTagKeysRequest) (<-chan *DescribeTagKeysResponse, <-chan error) {
	responseChan := make(chan *DescribeTagKeysResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTagKeys(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTagKeysWithCallback invokes the ddoscoo.DescribeTagKeys API asynchronously
func (client *Client) DescribeTagKeysWithCallback(request *DescribeTagKeysRequest, callback func(response *DescribeTagKeysResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTagKeysResponse
		var err error
		defer close(result)
		response, err = client.DescribeTagKeys(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTagKeysRequest is the request struct for api DescribeTagKeys
type DescribeTagKeysRequest struct {
	*requests.RpcRequest
	ResourceType    string           `position:"Query" name:"ResourceType"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeTagKeysResponse is the response struct for api DescribeTagKeys
type DescribeTagKeysResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	PageNumber int      `json:"PageNumber" xml:"PageNumber"`
	PageSize   int      `json:"PageSize" xml:"PageSize"`
	TotalCount int      `json:"TotalCount" xml:"TotalCount"`
	TagKeys    []TagKey `json:"TagKeys" xml:"TagKeys"`
}

// CreateDescribeTagKeysRequest creates a request to invoke DescribeTagKeys API
func CreateDescribeTagKeysRequest() (request *DescribeTagKeysRequest) {
	request = &DescribeTagKeysRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeTagKeys", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTagKeysResponse creates a response to parse from DescribeTagKeys response
func CreateDescribeTagKeysResponse() (response *DescribeTagKeysResponse) {
	response = &DescribeTagKeysResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
