package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTotalAttackMaxFlow invokes the ddoscoo.DescribeTotalAttackMaxFlow API synchronously
func (client *Client) DescribeTotalAttackMaxFlow(request *DescribeTotalAttackMaxFlowRequest) (response *DescribeTotalAttackMaxFlowResponse, err error) {
	response = CreateDescribeTotalAttackMaxFlowResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTotalAttackMaxFlowWithChan invokes the ddoscoo.DescribeTotalAttackMaxFlow API asynchronously
func (client *Client) DescribeTotalAttackMaxFlowWithChan(request *DescribeTotalAttackMaxFlowRequest) (<-chan *DescribeTotalAttackMaxFlowResponse, <-chan error) {
	responseChan := make(chan *DescribeTotalAttackMaxFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTotalAttackMaxFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTotalAttackMaxFlowWithCallback invokes the ddoscoo.DescribeTotalAttackMaxFlow API asynchronously
func (client *Client) DescribeTotalAttackMaxFlowWithCallback(request *DescribeTotalAttackMaxFlowRequest, callback func(response *DescribeTotalAttackMaxFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTotalAttackMaxFlowResponse
		var err error
		defer close(result)
		response, err = client.DescribeTotalAttackMaxFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTotalAttackMaxFlowRequest is the request struct for api DescribeTotalAttackMaxFlow
type DescribeTotalAttackMaxFlowRequest struct {
	*requests.RpcRequest
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	InstanceIds     *[]string        `position:"Query" name:"InstanceIds"  type:"Repeated"`
}

// DescribeTotalAttackMaxFlowResponse is the response struct for api DescribeTotalAttackMaxFlow
type DescribeTotalAttackMaxFlowResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Bps       int64  `json:"Bps" xml:"Bps"`
	Pps       int64  `json:"Pps" xml:"Pps"`
}

// CreateDescribeTotalAttackMaxFlowRequest creates a request to invoke DescribeTotalAttackMaxFlow API
func CreateDescribeTotalAttackMaxFlowRequest() (request *DescribeTotalAttackMaxFlowRequest) {
	request = &DescribeTotalAttackMaxFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeTotalAttackMaxFlow", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTotalAttackMaxFlowResponse creates a response to parse from DescribeTotalAttackMaxFlow response
func CreateDescribeTotalAttackMaxFlowResponse() (response *DescribeTotalAttackMaxFlowResponse) {
	response = &DescribeTotalAttackMaxFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
