package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBInstanceSwitchLog invokes the dds.DescribeDBInstanceSwitchLog API synchronously
func (client *Client) DescribeDBInstanceSwitchLog(request *DescribeDBInstanceSwitchLogRequest) (response *DescribeDBInstanceSwitchLogResponse, err error) {
	response = CreateDescribeDBInstanceSwitchLogResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBInstanceSwitchLogWithChan invokes the dds.DescribeDBInstanceSwitchLog API asynchronously
func (client *Client) DescribeDBInstanceSwitchLogWithChan(request *DescribeDBInstanceSwitchLogRequest) (<-chan *DescribeDBInstanceSwitchLogResponse, <-chan error) {
	responseChan := make(chan *DescribeDBInstanceSwitchLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBInstanceSwitchLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBInstanceSwitchLogWithCallback invokes the dds.DescribeDBInstanceSwitchLog API asynchronously
func (client *Client) DescribeDBInstanceSwitchLogWithCallback(request *DescribeDBInstanceSwitchLogRequest, callback func(response *DescribeDBInstanceSwitchLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBInstanceSwitchLogResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBInstanceSwitchLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBInstanceSwitchLogRequest is the request struct for api DescribeDBInstanceSwitchLog
type DescribeDBInstanceSwitchLogRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	StartTime       string           `position:"Query" name:"StartTime"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	DBInstanceId    string           `position:"Query" name:"DBInstanceId"`
	EndTime         string           `position:"Query" name:"EndTime"`
}

// DescribeDBInstanceSwitchLogResponse is the response struct for api DescribeDBInstanceSwitchLog
type DescribeDBInstanceSwitchLogResponse struct {
	*responses.BaseResponse
	RequestId    string         `json:"RequestId" xml:"RequestId"`
	DBInstanceId string         `json:"DBInstanceId" xml:"DBInstanceId"`
	TotalCount   int64          `json:"TotalCount" xml:"TotalCount"`
	PageSize     int64          `json:"PageSize" xml:"PageSize"`
	PageNumber   int64          `json:"PageNumber" xml:"PageNumber"`
	LogItems     []LogItemsItem `json:"LogItems" xml:"LogItems"`
}

// CreateDescribeDBInstanceSwitchLogRequest creates a request to invoke DescribeDBInstanceSwitchLog API
func CreateDescribeDBInstanceSwitchLogRequest() (request *DescribeDBInstanceSwitchLogRequest) {
	request = &DescribeDBInstanceSwitchLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "DescribeDBInstanceSwitchLog", "dds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBInstanceSwitchLogResponse creates a response to parse from DescribeDBInstanceSwitchLog response
func CreateDescribeDBInstanceSwitchLogResponse() (response *DescribeDBInstanceSwitchLogResponse) {
	response = &DescribeDBInstanceSwitchLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
