package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceRecoverTime invokes the dds.DescribeInstanceRecoverTime API synchronously
func (client *Client) DescribeInstanceRecoverTime(request *DescribeInstanceRecoverTimeRequest) (response *DescribeInstanceRecoverTimeResponse, err error) {
	response = CreateDescribeInstanceRecoverTimeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceRecoverTimeWithChan invokes the dds.DescribeInstanceRecoverTime API asynchronously
func (client *Client) DescribeInstanceRecoverTimeWithChan(request *DescribeInstanceRecoverTimeRequest) (<-chan *DescribeInstanceRecoverTimeResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceRecoverTimeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceRecoverTime(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceRecoverTimeWithCallback invokes the dds.DescribeInstanceRecoverTime API asynchronously
func (client *Client) DescribeInstanceRecoverTimeWithCallback(request *DescribeInstanceRecoverTimeRequest, callback func(response *DescribeInstanceRecoverTimeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceRecoverTimeResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceRecoverTime(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceRecoverTimeRequest is the request struct for api DescribeInstanceRecoverTime
type DescribeInstanceRecoverTimeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeInstanceRecoverTimeResponse is the response struct for api DescribeInstanceRecoverTime
type DescribeInstanceRecoverTimeResponse struct {
	*responses.BaseResponse
	RequestId     string                 `json:"RequestId" xml:"RequestId"`
	RestoreRanges []AvailableRestoreTime `json:"RestoreRanges" xml:"RestoreRanges"`
}

// CreateDescribeInstanceRecoverTimeRequest creates a request to invoke DescribeInstanceRecoverTime API
func CreateDescribeInstanceRecoverTimeRequest() (request *DescribeInstanceRecoverTimeRequest) {
	request = &DescribeInstanceRecoverTimeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "DescribeInstanceRecoverTime", "dds", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeInstanceRecoverTimeResponse creates a response to parse from DescribeInstanceRecoverTime response
func CreateDescribeInstanceRecoverTimeResponse() (response *DescribeInstanceRecoverTimeResponse) {
	response = &DescribeInstanceRecoverTimeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
