package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddDesensitizationRule invokes the dms_enterprise.AddDesensitizationRule API synchronously
func (client *Client) AddDesensitizationRule(request *AddDesensitizationRuleRequest) (response *AddDesensitizationRuleResponse, err error) {
	response = CreateAddDesensitizationRuleResponse()
	err = client.DoAction(request, response)
	return
}

// AddDesensitizationRuleWithChan invokes the dms_enterprise.AddDesensitizationRule API asynchronously
func (client *Client) AddDesensitizationRuleWithChan(request *AddDesensitizationRuleRequest) (<-chan *AddDesensitizationRuleResponse, <-chan error) {
	responseChan := make(chan *AddDesensitizationRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddDesensitizationRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddDesensitizationRuleWithCallback invokes the dms_enterprise.AddDesensitizationRule API asynchronously
func (client *Client) AddDesensitizationRuleWithCallback(request *AddDesensitizationRuleRequest, callback func(response *AddDesensitizationRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddDesensitizationRuleResponse
		var err error
		defer close(result)
		response, err = client.AddDesensitizationRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddDesensitizationRuleRequest is the request struct for api AddDesensitizationRule
type AddDesensitizationRuleRequest struct {
	*requests.RpcRequest
	FunctionParams  *[]map[string]string `position:"Body" name:"FunctionParams"  type:"Repeated"`
	RuleName        string               `position:"Query" name:"RuleName"`
	Tid             requests.Integer     `position:"Query" name:"Tid"`
	RuleDescription string               `position:"Query" name:"RuleDescription"`
	RuleType        string               `position:"Query" name:"RuleType"`
	FunctionType    string               `position:"Query" name:"FunctionType"`
}

// AddDesensitizationRuleResponse is the response struct for api AddDesensitizationRule
type AddDesensitizationRuleResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	RuleId       int    `json:"RuleId" xml:"RuleId"`
}

// CreateAddDesensitizationRuleRequest creates a request to invoke AddDesensitizationRule API
func CreateAddDesensitizationRuleRequest() (request *AddDesensitizationRuleRequest) {
	request = &AddDesensitizationRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "AddDesensitizationRule", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddDesensitizationRuleResponse creates a response to parse from AddDesensitizationRule response
func CreateAddDesensitizationRuleResponse() (response *AddDesensitizationRuleResponse) {
	response = &AddDesensitizationRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
