package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAuthorityTemplate invokes the dms_enterprise.ListAuthorityTemplate API synchronously
func (client *Client) ListAuthorityTemplate(request *ListAuthorityTemplateRequest) (response *ListAuthorityTemplateResponse, err error) {
	response = CreateListAuthorityTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// ListAuthorityTemplateWithChan invokes the dms_enterprise.ListAuthorityTemplate API asynchronously
func (client *Client) ListAuthorityTemplateWithChan(request *ListAuthorityTemplateRequest) (<-chan *ListAuthorityTemplateResponse, <-chan error) {
	responseChan := make(chan *ListAuthorityTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAuthorityTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAuthorityTemplateWithCallback invokes the dms_enterprise.ListAuthorityTemplate API asynchronously
func (client *Client) ListAuthorityTemplateWithCallback(request *ListAuthorityTemplateRequest, callback func(response *ListAuthorityTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAuthorityTemplateResponse
		var err error
		defer close(result)
		response, err = client.ListAuthorityTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAuthorityTemplateRequest is the request struct for api ListAuthorityTemplate
type ListAuthorityTemplateRequest struct {
	*requests.RpcRequest
	SearchKey  string           `position:"Query" name:"SearchKey"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	Tid        requests.Integer `position:"Query" name:"Tid"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// ListAuthorityTemplateResponse is the response struct for api ListAuthorityTemplate
type ListAuthorityTemplateResponse struct {
	*responses.BaseResponse
	RequestId                 string                    `json:"RequestId" xml:"RequestId"`
	ErrorCode                 string                    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage              string                    `json:"ErrorMessage" xml:"ErrorMessage"`
	Success                   bool                      `json:"Success" xml:"Success"`
	Tid                       int64                     `json:"Tid" xml:"Tid"`
	TotalCount                int64                     `json:"TotalCount" xml:"TotalCount"`
	AuthorityTemplateViewList AuthorityTemplateViewList `json:"AuthorityTemplateViewList" xml:"AuthorityTemplateViewList"`
}

// CreateListAuthorityTemplateRequest creates a request to invoke ListAuthorityTemplate API
func CreateListAuthorityTemplateRequest() (request *ListAuthorityTemplateRequest) {
	request = &ListAuthorityTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListAuthorityTemplate", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAuthorityTemplateResponse creates a response to parse from ListAuthorityTemplate response
func CreateListAuthorityTemplateResponse() (response *ListAuthorityTemplateResponse) {
	response = &ListAuthorityTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
