package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTaskFlowEdges invokes the dms_enterprise.UpdateTaskFlowEdges API synchronously
func (client *Client) UpdateTaskFlowEdges(request *UpdateTaskFlowEdgesRequest) (response *UpdateTaskFlowEdgesResponse, err error) {
	response = CreateUpdateTaskFlowEdgesResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTaskFlowEdgesWithChan invokes the dms_enterprise.UpdateTaskFlowEdges API asynchronously
func (client *Client) UpdateTaskFlowEdgesWithChan(request *UpdateTaskFlowEdgesRequest) (<-chan *UpdateTaskFlowEdgesResponse, <-chan error) {
	responseChan := make(chan *UpdateTaskFlowEdgesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTaskFlowEdges(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTaskFlowEdgesWithCallback invokes the dms_enterprise.UpdateTaskFlowEdges API asynchronously
func (client *Client) UpdateTaskFlowEdgesWithCallback(request *UpdateTaskFlowEdgesRequest, callback func(response *UpdateTaskFlowEdgesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTaskFlowEdgesResponse
		var err error
		defer close(result)
		response, err = client.UpdateTaskFlowEdges(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTaskFlowEdgesRequest is the request struct for api UpdateTaskFlowEdges
type UpdateTaskFlowEdgesRequest struct {
	*requests.RpcRequest
	DagId requests.Integer            `position:"Query" name:"DagId"`
	Tid   requests.Integer            `position:"Query" name:"Tid"`
	Edges *[]UpdateTaskFlowEdgesEdges `position:"Query" name:"Edges"  type:"Json"`
}

// UpdateTaskFlowEdgesEdges is a repeated param struct in UpdateTaskFlowEdgesRequest
type UpdateTaskFlowEdgesEdges struct {
	NodeEnd  string `name:"NodeEnd"`
	NodeFrom string `name:"NodeFrom"`
	Id       string `name:"Id"`
}

// UpdateTaskFlowEdgesResponse is the response struct for api UpdateTaskFlowEdges
type UpdateTaskFlowEdgesResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateUpdateTaskFlowEdgesRequest creates a request to invoke UpdateTaskFlowEdges API
func CreateUpdateTaskFlowEdgesRequest() (request *UpdateTaskFlowEdgesRequest) {
	request = &UpdateTaskFlowEdgesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "UpdateTaskFlowEdges", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateTaskFlowEdgesResponse creates a response to parse from UpdateTaskFlowEdges response
func CreateUpdateTaskFlowEdgesResponse() (response *UpdateTaskFlowEdgesResponse) {
	response = &UpdateTaskFlowEdgesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
